/*
 * Decompiled with CFR 0.152.
 */
package com.magicbroom.examplemod.render;

import com.magicbroom.examplemod.entity.MajoBroomEntity;
import com.magicbroom.examplemod.model.MajoBroomModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class MajoBroomEntityRenderer
extends EntityRenderer<MajoBroomEntity> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"ashenwitchbroom", (String)"textures/entity/majo_broom.png");
    private final MajoBroomModel<MajoBroomEntity> model;

    public MajoBroomEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new MajoBroomModel(context.bakeLayer(MajoBroomModel.LAYER_LOCATION));
    }

    public void render(MajoBroomEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        float time = (float)entity.tickCount + partialTicks;
        float hoverOffset = Mth.sin((float)(time * 0.1f)) * 0.05f;
        poseStack.translate(0.0, 1.5 + (double)hoverOffset, 0.0);
        poseStack.mulPose(Axis.YP.rotationDegrees(-entityYaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        poseStack.scale(1.0f, 1.0f, 1.0f);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(this.model.renderType(this.getTextureLocation(entity)));
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, -1);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(MajoBroomEntity entity) {
        return TEXTURE_LOCATION;
    }
}

