/*
 * Decompiled with CFR 0.152.
 */
package com.magicbroom.examplemod.data;

import com.magicbroom.examplemod.core.AshenWitchBroom;
import com.magicbroom.examplemod.data.BroomData;
import com.magicbroom.examplemod.entity.MajoBroomEntity;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;

public class BroomDataManager {
    private static final String DATA_FOLDER = "ashenwitchbroom";
    private static final String FILE_EXTENSION = ".dat";
    private static final ConcurrentHashMap<UUID, ReentrantReadWriteLock> playerLocks = new ConcurrentHashMap();

    private static ReentrantReadWriteLock getPlayerLock(UUID playerUUID) {
        return playerLocks.computeIfAbsent(playerUUID, k -> new ReentrantReadWriteLock());
    }

    private static File getPlayerBroomFile(ServerLevel level, UUID playerUUID) {
        File worldDir = level.getServer().getWorldPath(LevelResource.ROOT).toFile();
        File dataDir = new File(worldDir, DATA_FOLDER);
        if (!dataDir.exists()) {
            dataDir.mkdirs();
        }
        return new File(dataDir, playerUUID.toString() + FILE_EXTENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BroomData> loadPlayerBrooms(ServerLevel level, UUID playerUUID) {
        ReentrantReadWriteLock lock = BroomDataManager.getPlayerLock(playerUUID);
        lock.readLock().lock();
        try {
            ArrayList<BroomData> brooms = new ArrayList<BroomData>();
            File broomFile = BroomDataManager.getPlayerBroomFile(level, playerUUID);
            if (!broomFile.exists()) {
                ArrayList<BroomData> arrayList = brooms;
                return arrayList;
            }
            try {
                CompoundTag rootTag = NbtIo.readCompressed((Path)broomFile.toPath(), (NbtAccounter)NbtAccounter.unlimitedHeap());
                ListTag broomsList = rootTag.getList("brooms", 10);
                for (int i = 0; i < broomsList.size(); ++i) {
                    CompoundTag broomTag = broomsList.getCompound(i);
                    BroomData broomData = BroomData.fromNBT(broomTag);
                    brooms.add(broomData);
                }
            }
            catch (IOException e) {
                AshenWitchBroom.LOGGER.error("Failed to load broom data for player {}: {}", (Object)playerUUID, (Object)e.getMessage());
            }
            ArrayList<BroomData> arrayList = brooms;
            return arrayList;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePlayerBrooms(ServerLevel level, UUID playerUUID, List<BroomData> brooms) {
        ReentrantReadWriteLock lock = BroomDataManager.getPlayerLock(playerUUID);
        lock.writeLock().lock();
        try {
            File broomFile = BroomDataManager.getPlayerBroomFile(level, playerUUID);
            try {
                CompoundTag rootTag = new CompoundTag();
                ListTag broomsList = new ListTag();
                for (BroomData broomData : brooms) {
                    broomsList.add((Object)broomData.toNBT());
                }
                rootTag.put("brooms", (Tag)broomsList);
                NbtIo.writeCompressed((CompoundTag)rootTag, (Path)broomFile.toPath());
            }
            catch (IOException e) {
                AshenWitchBroom.LOGGER.error("Failed to save broom data for player {}: {}", (Object)playerUUID, (Object)e.getMessage());
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static void addBroom(ServerLevel level, UUID playerUUID, String broomName, ResourceKey<Level> dimension, BlockPos position, UUID entityUUID) {
        if (entityUUID == null) {
            throw new IllegalArgumentException("entityUUID cannot be null when adding broom data");
        }
        List<BroomData> brooms = BroomDataManager.loadPlayerBrooms(level, playerUUID);
        brooms.add(new BroomData(broomName, dimension, position, entityUUID));
        BroomDataManager.savePlayerBrooms(level, playerUUID, brooms);
        AshenWitchBroom.LOGGER.info("Added broom '{}' for player {} at {} in {} with entityUUID {}", new Object[]{broomName, playerUUID, position, dimension.location(), entityUUID});
    }

    public static boolean removeBroom(ServerLevel level, UUID playerUUID, String broomName) {
        List<BroomData> brooms = BroomDataManager.loadPlayerBrooms(level, playerUUID);
        boolean removed = brooms.removeIf(broom -> broom.getBroomName().equals(broomName));
        if (removed) {
            BroomDataManager.savePlayerBrooms(level, playerUUID, brooms);
            AshenWitchBroom.LOGGER.info("Removed broom '{}' for player {}", (Object)broomName, (Object)playerUUID);
        }
        return removed;
    }

    public static boolean updateBroom(ServerLevel level, UUID playerUUID, String broomName, ResourceKey<Level> newDimension, BlockPos newPosition, UUID newEntityUUID) {
        if (newEntityUUID == null) {
            throw new IllegalArgumentException("newEntityUUID cannot be null when updating broom data");
        }
        List<BroomData> brooms = BroomDataManager.loadPlayerBrooms(level, playerUUID);
        for (BroomData broom : brooms) {
            if (!broom.getBroomName().equals(broomName)) continue;
            broom.setDimension(newDimension);
            broom.setPosition(newPosition);
            if (newEntityUUID != null) {
                broom.setEntityUUID(newEntityUUID);
            }
            BroomDataManager.savePlayerBrooms(level, playerUUID, brooms);
            AshenWitchBroom.LOGGER.info("Updated broom '{}' for player {} to {} in {} with entityUUID {}", new Object[]{broomName, playerUUID, newPosition, newDimension.location(), newEntityUUID});
            return true;
        }
        return false;
    }

    public static BroomData findBroom(ServerLevel level, UUID playerUUID, String broomName) {
        List<BroomData> brooms = BroomDataManager.loadPlayerBrooms(level, playerUUID);
        for (BroomData broom : brooms) {
            if (!broom.getBroomName().equals(broomName)) continue;
            return broom;
        }
        return null;
    }

    public static BroomData findBroomByEntityUUID(ServerLevel level, UUID playerUUID, UUID entityUUID) {
        List<BroomData> brooms = BroomDataManager.loadPlayerBrooms(level, playerUUID);
        for (BroomData broom : brooms) {
            if (!entityUUID.equals(broom.getEntityUUID())) continue;
            return broom;
        }
        return null;
    }

    public static boolean validateBroomEntityUUID(ServerLevel level, UUID playerUUID, String broomName, UUID expectedEntityUUID) {
        BroomData broom = BroomDataManager.findBroom(level, playerUUID, broomName);
        if (broom == null) {
            AshenWitchBroom.LOGGER.debug("Broom '{}' not found for player {}", (Object)broomName, (Object)playerUUID);
            return false;
        }
        UUID storedUUID = broom.getEntityUUID();
        if (storedUUID == null) {
            AshenWitchBroom.LOGGER.warn("Broom '{}' has no entityUUID, removing invalid data for player {}", (Object)broomName, (Object)playerUUID);
            BroomDataManager.removeBroom(level, playerUUID, broomName);
            return false;
        }
        if (!storedUUID.equals(expectedEntityUUID)) {
            AshenWitchBroom.LOGGER.warn("Broom '{}' entity UUID mismatch for player {}. Expected: {}, Stored: {}. Removing stale data.", new Object[]{broomName, playerUUID, expectedEntityUUID, storedUUID});
            BroomDataManager.removeBroom(level, playerUUID, broomName);
            return false;
        }
        return true;
    }

    public static CompletableFuture<Boolean> verifyBroomExists(ServerPlayer player, String broomName) {
        UUID playerUUID = player.getUUID();
        ReentrantReadWriteLock lock = BroomDataManager.getPlayerLock(playerUUID);
        if (lock.isWriteLocked()) {
            AshenWitchBroom.LOGGER.debug("Skipping broom verification for player {} during write operation", (Object)playerUUID);
            return CompletableFuture.completedFuture(false);
        }
        BroomData broomData = BroomDataManager.findBroom((ServerLevel)player.level(), playerUUID, broomName);
        if (broomData == null) {
            AshenWitchBroom.LOGGER.debug("Broom '{}' not found in data for player {}", (Object)broomName, (Object)playerUUID);
            return CompletableFuture.completedFuture(false);
        }
        UUID targetEntityUUID = broomData.getEntityUUID();
        if (targetEntityUUID == null) {
            AshenWitchBroom.LOGGER.warn("Broom '{}' has no entityUUID, removing invalid data for player {}", (Object)broomName, (Object)playerUUID);
            BroomDataManager.removeBroom((ServerLevel)player.level(), playerUUID, broomName);
            return CompletableFuture.completedFuture(false);
        }
        ServerLevel targetLevel = player.getServer().getLevel(broomData.getDimension());
        if (targetLevel == null) {
            AshenWitchBroom.LOGGER.warn("Target dimension {} not found for broom '{}'", (Object)broomData.getDimension().location(), (Object)broomName);
            return CompletableFuture.completedFuture(false);
        }
        return CompletableFuture.supplyAsync(() -> {
            BlockPos broomPos = broomData.getPosition();
            ChunkPos centerChunk = new ChunkPos(broomPos);
            ArrayList<ChunkPos> chunksToLoad = new ArrayList<ChunkPos>();
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    chunksToLoad.add(new ChunkPos(centerChunk.x + x, centerChunk.z + z));
                }
            }
            for (ChunkPos chunkPos : chunksToLoad) {
                targetLevel.getChunk(chunkPos.x, chunkPos.z);
            }
            Entity targetEntity = targetLevel.getEntity(targetEntityUUID);
            if (targetEntity instanceof MajoBroomEntity) {
                MajoBroomEntity broomEntity = (MajoBroomEntity)targetEntity;
                if (broomData.getBroomName().equals(broomEntity.getBroomName()) && playerUUID.equals(broomEntity.getOwnerUUID())) {
                    AshenWitchBroom.LOGGER.debug("Broom '{}' verified by UUID {} for player {}", new Object[]{broomName, targetEntityUUID, playerUUID});
                    return true;
                }
                AshenWitchBroom.LOGGER.warn("Broom entity UUID {} found but name/owner mismatch. Expected: {}/{}, Found: {}/{}", new Object[]{targetEntityUUID, broomData.getBroomName(), playerUUID, broomEntity.getBroomName(), broomEntity.getOwnerUUID()});
                return false;
            }
            AshenWitchBroom.LOGGER.debug("Broom entity with UUID {} not found after chunk loading, removing stale data", (Object)targetEntityUUID);
            BroomDataManager.removeBroom(targetLevel, playerUUID, broomName);
            return false;
        });
    }

    public static String generateUniqueBroomName(ServerLevel level, UUID playerUUID) {
        List<BroomData> existingBrooms = BroomDataManager.loadPlayerBrooms(level, playerUUID);
        int counter = 1;
        String baseName = "\u626b\u5e1a";
        String broomName = baseName + counter;
        boolean nameExists = true;
        while (nameExists) {
            String currentName = broomName;
            nameExists = existingBrooms.stream().anyMatch(broom -> broom.getBroomName().equals(currentName));
            if (!nameExists) continue;
            broomName = baseName + ++counter;
        }
        return broomName;
    }
}

