/*
 * Decompiled with CFR 0.152.
 */
package com.magicbroom.examplemod.entity;

import com.magicbroom.examplemod.core.AshenWitchBroom;
import com.magicbroom.examplemod.core.Config;
import com.magicbroom.examplemod.data.BroomDataManager;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class MajoBroomEntity
extends Entity {
    private static final EntityDataAccessor<Float> FORWARD_INPUT = SynchedEntityData.defineId(MajoBroomEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> STRAFE_INPUT = SynchedEntityData.defineId(MajoBroomEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> JUMPING = SynchedEntityData.defineId(MajoBroomEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SHIFT_KEY_DOWN = SynchedEntityData.defineId(MajoBroomEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SPRINTING = SynchedEntityData.defineId(MajoBroomEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CUSTOM_UP = SynchedEntityData.defineId(MajoBroomEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CUSTOM_DOWN = SynchedEntityData.defineId(MajoBroomEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CONTROL_MODE = SynchedEntityData.defineId(MajoBroomEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> PLAYER_LEVEL = SynchedEntityData.defineId(MajoBroomEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> CONFIG_SPEED = SynchedEntityData.defineId(MajoBroomEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> CONFIG_ADVANCED_MODE = SynchedEntityData.defineId(MajoBroomEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SPEED_BOOST_ACTIVE = SynchedEntityData.defineId(MajoBroomEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SPEED_BOOST_TOGGLED = SynchedEntityData.defineId(MajoBroomEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private boolean forward = false;
    private boolean backward = false;
    private boolean left = false;
    private boolean right = false;
    private boolean up = false;
    private boolean down = false;
    private boolean lastCtrlState = false;
    private float deltaRotation = 0.0f;
    private static final float TURN_SPEED = 2.5f;
    private static final double ROTATION_DECAY = 0.7;
    private String broomName = null;
    private UUID ownerUUID = null;
    private int positionUpdateCounter = 0;

    public boolean isSpeedBoostActive() {
        return (Boolean)this.entityData.get(SPEED_BOOST_ACTIVE);
    }

    public void setSpeedBoostActive(boolean active) {
        this.entityData.set(SPEED_BOOST_ACTIVE, (Object)active);
    }

    public void toggleSpeedBoost() {
        this.setSpeedBoostActive(!this.isSpeedBoostActive());
    }

    public void setBroomInfo(String broomName, UUID ownerUUID) {
        this.broomName = broomName;
        this.ownerUUID = ownerUUID;
    }

    public String getBroomName() {
        return this.broomName;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    private double getMomentumDecay() {
        return ((Config.BroomMode)((Object)Config.BROOM_MODE.get())).getMomentumDecay();
    }

    public void handleCtrlToggle(boolean ctrlPressed) {
        boolean hasMovementInput;
        boolean bl = hasMovementInput = ((Float)this.entityData.get(FORWARD_INPUT)).floatValue() != 0.0f || ((Float)this.entityData.get(STRAFE_INPUT)).floatValue() != 0.0f || (Boolean)this.entityData.get(JUMPING) != false || (Boolean)this.entityData.get(CUSTOM_UP) != false || (Boolean)this.entityData.get(CUSTOM_DOWN) != false;
        if (!hasMovementInput) {
            this.entityData.set(SPEED_BOOST_TOGGLED, (Object)false);
        } else if (ctrlPressed && !this.lastCtrlState) {
            this.entityData.set(SPEED_BOOST_TOGGLED, (Object)((Boolean)this.entityData.get(SPEED_BOOST_TOGGLED) == false ? 1 : 0));
        }
        this.lastCtrlState = ctrlPressed;
        this.setSpeedBoostActive((Boolean)this.entityData.get(SPEED_BOOST_TOGGLED) != false && hasMovementInput);
    }

    public MajoBroomEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(true);
        this.recalculateBoundingBox();
    }

    private void recalculateBoundingBox() {
        float length = 1.0f;
        float height = 0.5f;
        float width = 1.0f;
        float yOffset = 0.5f;
        float zOffset = 0.0f;
        AABB aabb = new AABB(this.getX() - (double)(length / 2.0f), this.getY() + (double)yOffset, this.getZ() - (double)(width / 2.0f) + (double)zOffset, this.getX() + (double)(length / 2.0f), this.getY() + (double)yOffset + (double)height, this.getZ() + (double)(width / 2.0f) + (double)zOffset);
        this.setBoundingBox(aabb);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(FORWARD_INPUT, (Object)Float.valueOf(0.0f));
        builder.define(STRAFE_INPUT, (Object)Float.valueOf(0.0f));
        builder.define(JUMPING, (Object)false);
        builder.define(SHIFT_KEY_DOWN, (Object)false);
        builder.define(SPRINTING, (Object)false);
        builder.define(CUSTOM_UP, (Object)false);
        builder.define(CUSTOM_DOWN, (Object)false);
        builder.define(CONTROL_MODE, (Object)false);
        builder.define(PLAYER_LEVEL, (Object)0);
        builder.define(CONFIG_SPEED, (Object)100);
        builder.define(CONFIG_ADVANCED_MODE, (Object)false);
        builder.define(SPEED_BOOST_ACTIVE, (Object)false);
        builder.define(SPEED_BOOST_TOGGLED, (Object)false);
    }

    public void setPos(double x, double y, double z) {
        super.setPos(x, y, z);
        if (this.level() != null) {
            this.recalculateBoundingBox();
        }
    }

    public void tick() {
        super.tick();
        if (this.isControlledByLocalInstance()) {
            this.updateControlFromInput();
            if (this.level().isClientSide) {
                this.controlBoat();
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
        }
        if (!this.level().isClientSide) {
            LivingEntity livingEntity;
            boolean shouldResetBoost = false;
            if (!this.isVehicle()) {
                shouldResetBoost = true;
            } else if (this.getDeltaMovement().lengthSqr() < 0.001) {
                shouldResetBoost = true;
            }
            if (shouldResetBoost && this.isSpeedBoostActive()) {
                this.setSpeedBoostActive(false);
                this.lastCtrlState = false;
            }
            if (this.isVehicle() && (livingEntity = this.getControllingPassenger()) instanceof Player) {
                Player player = (Player)livingEntity;
                this.updateControlFromInput();
            } else {
                this.setDeltaMovement(Vec3.ZERO);
            }
        }
    }

    private void updateControlFromInput() {
        float forwardInput = ((Float)this.entityData.get(FORWARD_INPUT)).floatValue();
        float strafeInput = ((Float)this.entityData.get(STRAFE_INPUT)).floatValue();
        boolean jumping = (Boolean)this.entityData.get(JUMPING);
        boolean shiftKeyDown = (Boolean)this.entityData.get(SHIFT_KEY_DOWN);
        boolean sprinting = (Boolean)this.entityData.get(SPRINTING);
        this.forward = forwardInput > 0.0f;
        this.backward = forwardInput < 0.0f;
        this.left = strafeInput > 0.0f;
        this.right = strafeInput < 0.0f;
        this.up = (Boolean)this.entityData.get(CUSTOM_UP);
        this.down = (Boolean)this.entityData.get(CUSTOM_DOWN);
    }

    public void controlBoat() {
        if (this.isVehicle()) {
            Vec3 v3d;
            float f = 0.0f;
            float baseSpeed = 0.9f;
            float baseSpeedPercentage = ((Double)Config.BASE_SPEED_PERCENTAGE.get()).floatValue() / 100.0f;
            float speedBoostMultiplier = this.isSpeedBoostActive() ? ((Double)Config.SPEED_BOOST_MULTIPLIER.get()).floatValue() : 1.0f;
            float finalSpeedMultiplier = baseSpeed * baseSpeedPercentage * speedBoostMultiplier;
            if (this.left) {
                this.deltaRotation -= 2.5f;
            }
            if (this.right) {
                this.deltaRotation += 2.5f;
            }
            if (Math.abs(this.deltaRotation) > 0.01f) {
                float oldYRot = this.getYRot();
                this.setYRot(this.getYRot() + this.deltaRotation);
                this.syncPlayerViewWithBroomTurning(this.deltaRotation);
                this.deltaRotation = (float)((double)this.deltaRotation * 0.7);
            }
            if (Math.abs(this.deltaRotation) > 0.1f && !this.forward && !this.backward) {
                f += 0.005f * finalSpeedMultiplier * Math.abs(this.deltaRotation) / 2.5f;
            }
            if (this.forward) {
                f += 0.072f * finalSpeedMultiplier;
            }
            if (this.backward) {
                f -= 0.036f * finalSpeedMultiplier;
            }
            Vec3 currentVelocity = this.getDeltaMovement();
            Vec3 thrustVector = new Vec3((double)(Mth.sin((float)(-this.getYRot() * ((float)Math.PI / 180))) * f), 0.0, (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * f));
            if (Math.abs(this.deltaRotation) > 0.1f) {
                Vec3 decayedVelocity = new Vec3(currentVelocity.x * this.getMomentumDecay(), currentVelocity.y, currentVelocity.z * this.getMomentumDecay());
                v3d = decayedVelocity.add(thrustVector);
            } else {
                v3d = currentVelocity.add(thrustVector);
            }
            double maxHorizontalSpeed = finalSpeedMultiplier;
            double currentHorizontalSpeed = Math.sqrt(v3d.x * v3d.x + v3d.z * v3d.z);
            if (currentHorizontalSpeed > maxHorizontalSpeed) {
                double scale = maxHorizontalSpeed / currentHorizontalSpeed;
                v3d = new Vec3(v3d.x * scale, v3d.y, v3d.z * scale);
            }
            if (!(this.forward || this.backward || this.left || this.right || !(Math.abs(this.deltaRotation) < 0.1f))) {
                v3d = new Vec3(v3d.x * 0.95, v3d.y, v3d.z * 0.95);
                double naturalDeceleration = 0.02;
                if (Math.abs(v3d.x) > naturalDeceleration) {
                    v3d = new Vec3(v3d.x - Math.signum(v3d.x) * naturalDeceleration, v3d.y, v3d.z);
                }
                if (Math.abs(v3d.z) > naturalDeceleration) {
                    v3d = new Vec3(v3d.x, v3d.y, v3d.z - Math.signum(v3d.z) * naturalDeceleration);
                }
                if (Math.abs(v3d.x) < 0.01 && Math.abs(v3d.z) < 0.01) {
                    v3d = new Vec3(0.0, v3d.y, 0.0);
                }
            }
            float currentY = (float)v3d.y;
            float maxYspeed = 0.6f * finalSpeedMultiplier;
            float yacc = 0.05f * finalSpeedMultiplier;
            float ydec = 0.02f;
            if (!this.up && !this.down) {
                currentY *= 0.95f;
            }
            if (currentY > 0.0f) {
                if (!this.up || !this.down) {
                    currentY = this.up ? (currentY + yacc > maxYspeed ? maxYspeed : (currentY += yacc)) : (this.down ? (currentY -= yacc) : (currentY -= ydec));
                }
            } else if (!this.up || !this.down) {
                currentY = this.down ? (currentY - yacc < -maxYspeed ? -maxYspeed : (currentY -= yacc)) : (this.up ? (currentY += yacc) : (currentY += ydec));
            }
            if ((double)Math.abs(currentY) <= 0.03) {
                currentY = 0.0f;
            }
            this.setDeltaMovement(v3d.x, currentY, v3d.z);
        }
    }

    public void updatePlayerInput(float forward, float strafe, boolean jumping, boolean shiftKeyDown, boolean sprinting, boolean customUp, boolean customDown, boolean ctrlPressed) {
        this.entityData.set(FORWARD_INPUT, (Object)Float.valueOf(forward));
        this.entityData.set(STRAFE_INPUT, (Object)Float.valueOf(strafe));
        this.entityData.set(JUMPING, (Object)jumping);
        this.entityData.set(SHIFT_KEY_DOWN, (Object)shiftKeyDown);
        this.entityData.set(SPRINTING, (Object)sprinting);
        this.entityData.set(CUSTOM_UP, (Object)customUp);
        this.entityData.set(CUSTOM_DOWN, (Object)customDown);
        this.handleCtrlToggle(ctrlPressed);
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        Player player;
        Entity entity;
        if (!this.level().isClientSide && (entity = damageSource.getEntity()) instanceof Player && (player = (Player)entity).isShiftKeyDown()) {
            if (this.broomName != null && this.ownerUUID != null && this.ownerUUID.equals(player.getUUID())) {
                boolean isValid = BroomDataManager.validateBroomEntityUUID((ServerLevel)this.level(), this.ownerUUID, this.broomName, this.getUUID());
                if (isValid) {
                    BroomDataManager.removeBroom((ServerLevel)this.level(), this.ownerUUID, this.broomName);
                    player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.broom_collected", (Object[])new Object[]{this.broomName}));
                    AshenWitchBroom.LOGGER.info("Player {} collected broom '{}' at {}", new Object[]{player.getName().getString(), this.broomName, this.blockPosition()});
                } else {
                    player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.broom_data_mismatch"));
                    AshenWitchBroom.LOGGER.warn("UUID validation failed when collecting broom '{}', data already cleaned up", (Object)this.broomName);
                }
            } else if (this.broomName != null && this.ownerUUID != null && !this.ownerUUID.equals(player.getUUID())) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.not_owner"));
                return false;
            }
            ItemStack broomItem = new ItemStack((ItemLike)AshenWitchBroom.MAJO_BROOM_ITEM.get());
            ItemStack mainHandItem = player.getMainHandItem();
            if (mainHandItem.isEmpty()) {
                player.getInventory().setItem(player.getInventory().selected, broomItem);
                this.discard();
                return false;
            }
            if (player.getInventory().add(broomItem)) {
                this.discard();
                return false;
            }
            player.drop(broomItem, false);
            this.discard();
            return false;
        }
        return false;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        if (!this.level().isClientSide) {
            if (!this.isVehicle()) {
                player.startRiding((Entity)this);
            } else {
                this.ejectPassengers();
                if (this.broomName != null && this.ownerUUID != null) {
                    this.updateBroomPositionSync();
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected void removePassenger(Entity passenger) {
        super.removePassenger(passenger);
        if (!this.level().isClientSide && this.broomName != null && this.ownerUUID != null) {
            this.updateBroomPositionSync();
            AshenWitchBroom.LOGGER.debug("Player {} dismounted broom '{}', position synced", (Object)passenger.getName().getString(), (Object)this.broomName);
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("BroomName", 8)) {
            this.broomName = compound.getString("BroomName");
        }
        if (compound.contains("OwnerUUID", 8)) {
            try {
                this.ownerUUID = UUID.fromString(compound.getString("OwnerUUID"));
            }
            catch (IllegalArgumentException e) {
                AshenWitchBroom.LOGGER.warn("Invalid owner UUID in broom data: {}", (Object)compound.getString("OwnerUUID"));
            }
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        if (this.broomName != null) {
            compound.putString("BroomName", this.broomName);
        }
        if (this.ownerUUID != null) {
            compound.putString("OwnerUUID", this.ownerUUID.toString());
        }
    }

    public boolean isPickable() {
        return true;
    }

    public boolean isPushable() {
        return true;
    }

    protected boolean canAddPassenger(Entity passenger) {
        return this.getPassengers().isEmpty() && passenger instanceof Player;
    }

    public LivingEntity getControllingPassenger() {
        Entity passenger = this.getFirstPassenger();
        if (passenger instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)passenger;
            return livingEntity;
        }
        return null;
    }

    public boolean isControlledByLocalInstance() {
        return this.isVehicle() && this.getControllingPassenger() != null;
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        if (this.hasPassenger(passenger)) {
            float time = this.tickCount;
            float hoverOffset = Mth.sin((float)(time * 0.1f)) * 0.05f;
            double yOffset = 0.2 + (double)hoverOffset;
            double forwardOffset = 0.1;
            float yaw = this.getYRot() * ((float)Math.PI / 180);
            double xOffset = -Math.sin(yaw) * forwardOffset;
            double zOffset = Math.cos(yaw) * forwardOffset;
            moveFunction.accept(passenger, this.getX() + xOffset, this.getY() + yOffset, this.getZ() + zOffset);
            if (!this.level().isClientSide && this.broomName != null && this.ownerUUID != null) {
                ++this.positionUpdateCounter;
                if (this.positionUpdateCounter >= 5) {
                    this.updateBroomPositionAsync();
                    this.positionUpdateCounter = 0;
                }
            }
        }
    }

    private void updateBroomPositionSync() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos currentPos = this.blockPosition();
            BroomDataManager.updateBroom(serverLevel, this.ownerUUID, this.broomName, (ResourceKey<Level>)this.level().dimension(), currentPos, this.getUUID());
            AshenWitchBroom.LOGGER.debug("Sync updated broom '{}' position to {} in {}", new Object[]{this.broomName, currentPos, this.level().dimension().location()});
        }
    }

    private void updateBroomPositionAsync() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos currentPos = this.blockPosition();
            ResourceKey dimension = this.level().dimension();
            String broomName = this.broomName;
            UUID ownerUUID = this.ownerUUID;
            CompletableFuture.runAsync(() -> BroomDataManager.updateBroom(serverLevel, ownerUUID, broomName, (ResourceKey<Level>)dimension, currentPos, this.getUUID()));
        }
    }

    public void remove(Entity.RemovalReason reason) {
        if (!this.level().isClientSide && reason != Entity.RemovalReason.DISCARDED && this.broomName != null && this.ownerUUID != null) {
            boolean isValid = BroomDataManager.validateBroomEntityUUID((ServerLevel)this.level(), this.ownerUUID, this.broomName, this.getUUID());
            if (isValid) {
                BroomDataManager.removeBroom((ServerLevel)this.level(), this.ownerUUID, this.broomName);
                AshenWitchBroom.LOGGER.info("Broom '{}' owned by {} was removed due to: {}", new Object[]{this.broomName, this.ownerUUID, reason});
            } else {
                AshenWitchBroom.LOGGER.warn("UUID validation failed when removing broom '{}', data already cleaned up", (Object)this.broomName);
            }
        }
        super.remove(reason);
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void syncPlayerViewWithBroomTurning(float deltaRotation) {
        Player controllingPlayer;
        if (this.level().isClientSide && (controllingPlayer = (Player)this.getControllingPassenger()) != null && controllingPlayer == Minecraft.getInstance().player) {
            float currentYaw = controllingPlayer.getYRot();
            controllingPlayer.setYRot(currentYaw + deltaRotation);
            controllingPlayer.yRotO = controllingPlayer.getYRot();
        }
    }
}

