/*
 * Decompiled with CFR 0.152.
 */
package com.magicbroom.examplemod.network;

import com.magicbroom.examplemod.entity.MajoBroomEntity;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record RidePack(int eid, boolean ride) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RidePack> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"ashenwitchbroom", (String)"ride_pack"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RidePack> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, RidePack::eid, (StreamCodec)ByteBufCodecs.BOOL, RidePack::ride, RidePack::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleServer(RidePack packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            ServerLevel level = player.serverLevel();
            Entity entity = level.getEntity(packet.eid);
            if (entity instanceof MajoBroomEntity) {
                MajoBroomEntity broomEntity = (MajoBroomEntity)entity;
                if (packet.ride) {
                    if (broomEntity.getPassengers().isEmpty()) {
                        player.startRiding((Entity)broomEntity);
                    }
                } else if (player.getVehicle() == broomEntity) {
                    player.stopRiding();
                }
            }
        });
    }
}

