/*
 * Decompiled with CFR 0.152.
 */
package com.magicbroom.examplemod.command;

import com.magicbroom.examplemod.core.AshenWitchBroom;
import com.magicbroom.examplemod.core.Config;
import com.magicbroom.examplemod.data.BroomData;
import com.magicbroom.examplemod.data.BroomDataManager;
import com.magicbroom.examplemod.entity.MajoBroomEntity;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class BroomCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"broom").then(((LiteralArgumentBuilder)Commands.literal((String)"detect").executes(BroomCommand::executeDetect)).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(source -> source.hasPermission(2))).executes(BroomCommand::executeDetectPlayer)))).then(((LiteralArgumentBuilder)Commands.literal((String)"stats").executes(BroomCommand::executeStats)).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(source -> source.hasPermission(2))).executes(BroomCommand::executeStatsPlayer)))).then(((LiteralArgumentBuilder)Commands.literal((String)"cleanup").executes(BroomCommand::executeCleanup)).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(source -> source.hasPermission(2))).executes(BroomCommand::executeCleanupPlayer)))).then(Commands.literal((String)"help").executes(BroomCommand::executeHelp))).executes(BroomCommand::executeHelp));
    }

    private static int executeDetect(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return BroomCommand.executeDetectForPlayer(source, player);
        }
        source.sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.broom.detect.player_only"));
        return 0;
    }

    private static int executeDetectPlayer(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            ServerPlayer targetPlayer = EntityArgument.getPlayer(context, (String)"player");
            return BroomCommand.executeDetectForPlayer(source, targetPlayer);
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.translatable((String)"commands.broom.detect.player_not_found"));
            return 0;
        }
    }

    private static int executeDetectForPlayer(CommandSourceStack source, ServerPlayer player) {
        UUID playerUUID;
        ServerLevel level = player.serverLevel();
        List<BroomData> brooms = BroomDataManager.loadPlayerBrooms(level, playerUUID = player.getUUID());
        if (brooms.isEmpty()) {
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.result_title"), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.player_info", (Object[])new Object[]{player.getDisplayName().getString()}), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.no_brooms_status"), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
            return 1;
        }
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.result_title"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
        ChatFormatting broomCountColor = brooms.size() > 10 ? ChatFormatting.GREEN : (brooms.size() > 5 ? ChatFormatting.YELLOW : ChatFormatting.WHITE);
        MutableComponent broomCountComponent = Component.literal((String)String.valueOf(brooms.size())).withStyle(broomCountColor);
        source.sendSuccess(() -> BroomCommand.lambda$executeDetectForPlayer$10(player, (Component)broomCountComponent), false);
        source.sendSuccess(() -> Component.literal((String)""), false);
        for (int i = 0; i < brooms.size(); ++i) {
            BroomData broom = brooms.get(i);
            int index = i + 1;
            MutableComponent indexComponent = Component.literal((String)String.valueOf(index)).withStyle(ChatFormatting.YELLOW);
            source.sendSuccess(() -> BroomCommand.lambda$executeDetectForPlayer$12((Component)indexComponent, broom), false);
            BlockPos pos = broom.getPosition();
            String dimensionName = broom.getDimension().location().toString();
            String formattedDimension = dimensionName.replace("minecraft:", "").replace("_", " ");
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.position", (Object[])new Object[]{formattedDimension, pos.getX(), pos.getY(), pos.getZ()}), false);
            UUID entityUUID = broom.getEntityUUID();
            if (entityUUID != null) {
                source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.entity_uuid", (Object[])new Object[]{entityUUID.toString()}), false);
                ServerLevel targetLevel = player.getServer().getLevel(broom.getDimension());
                if (targetLevel != null) {
                    Entity entity = targetLevel.getEntity(entityUUID);
                    if (entity instanceof MajoBroomEntity) {
                        MajoBroomEntity broomEntity = (MajoBroomEntity)entity;
                        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.status_valid"), false);
                    } else {
                        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.status_invalid_entity"), false);
                    }
                } else {
                    source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.status_invalid_dimension"), false);
                }
            } else {
                source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.entity_missing"), false);
                source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.status_no_uuid"), false);
            }
            if (broom.getDimension().equals((Object)level.dimension())) {
                double distance = Math.sqrt(broom.getDistanceSquared(player.blockPosition(), (ResourceKey<Level>)level.dimension()));
                ChatFormatting distanceColor = distance <= 50.0 ? ChatFormatting.GREEN : (distance <= 200.0 ? ChatFormatting.YELLOW : ChatFormatting.RED);
                String formattedDistance = String.format("%.2f", distance);
                MutableComponent distanceComponent = Component.literal((String)formattedDistance).withStyle(distanceColor);
                source.sendSuccess(() -> BroomCommand.lambda$executeDetectForPlayer$20((Component)distanceComponent), false);
            } else {
                source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.distance_cross_dimension"), false);
            }
            if (i >= brooms.size() - 1) continue;
            source.sendSuccess(() -> Component.literal((String)""), false);
        }
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
        return 1;
    }

    private static int executeStats(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return BroomCommand.executeStatsForPlayer(source, player);
        }
        source.sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.broom.stats.player_only"));
        return 0;
    }

    private static int executeStatsPlayer(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            ServerPlayer targetPlayer = EntityArgument.getPlayer(context, (String)"player");
            return BroomCommand.executeStatsForPlayer(source, targetPlayer);
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.translatable((String)"commands.broom.stats.player_not_found"));
            return 0;
        }
    }

    private static int executeStatsForPlayer(CommandSourceStack source, ServerPlayer player) {
        ServerLevel level = player.serverLevel();
        List<BroomData> brooms = BroomDataManager.loadPlayerBrooms(level, player.getUUID());
        int storedBrooms = brooms.size();
        int inventoryBrooms = 0;
        for (ItemStack itemStack : player.getInventory().items) {
            if (itemStack.getItem() != AshenWitchBroom.MAJO_BROOM_ITEM.get()) continue;
            inventoryBrooms += itemStack.getCount();
        }
        int finalInventoryBrooms = inventoryBrooms;
        int totalBrooms = storedBrooms + inventoryBrooms;
        ResourceKey currentDimension = player.level().dimension();
        long currentDimensionBrooms = brooms.stream().filter(broom -> broom.getDimension().equals((Object)currentDimension)).count();
        int nearbyRange = (Integer)Config.NEARBY_SEARCH_RANGE.get();
        BlockPos playerPos = player.blockPosition();
        long nearbyBrooms = brooms.stream().filter(broom -> broom.getDimension().equals((Object)currentDimension)).filter(broom -> broom.getDistanceSquared(playerPos, (ResourceKey<Level>)currentDimension) <= (double)(nearbyRange * nearbyRange)).count();
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.stats.title"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.player_info", (Object[])new Object[]{player.getDisplayName().getString()}), false);
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.stats.count_section"), false);
        ChatFormatting totalColor = totalBrooms > 10 ? ChatFormatting.GREEN : (totalBrooms > 5 ? ChatFormatting.YELLOW : ChatFormatting.WHITE);
        MutableComponent totalComponent = Component.literal((String)String.valueOf(totalBrooms)).withStyle(totalColor);
        source.sendSuccess(() -> BroomCommand.lambda$executeStatsForPlayer$33((Component)totalComponent), false);
        ChatFormatting inventoryColor = finalInventoryBrooms > 0 ? ChatFormatting.GREEN : ChatFormatting.GRAY;
        MutableComponent inventoryComponent = Component.literal((String)String.valueOf(finalInventoryBrooms)).withStyle(inventoryColor);
        source.sendSuccess(() -> BroomCommand.lambda$executeStatsForPlayer$34((Component)inventoryComponent), false);
        ChatFormatting nearbyColor = nearbyBrooms > 0L ? ChatFormatting.GREEN : ChatFormatting.GRAY;
        MutableComponent nearbyComponent = Component.literal((String)String.valueOf(nearbyBrooms)).withStyle(nearbyColor);
        source.sendSuccess(() -> BroomCommand.lambda$executeStatsForPlayer$35(nearbyRange, (Component)nearbyComponent), false);
        ChatFormatting currentWorldColor = currentDimensionBrooms > 0L ? ChatFormatting.GREEN : ChatFormatting.GRAY;
        String dimensionName = currentDimension.location().toString().replace("minecraft:", "").replace("_", " ");
        MutableComponent currentDimensionComponent = Component.literal((String)String.valueOf(currentDimensionBrooms)).withStyle(currentWorldColor);
        source.sendSuccess(() -> BroomCommand.lambda$executeStatsForPlayer$36(dimensionName, (Component)currentDimensionComponent), false);
        ChatFormatting storedColor = storedBrooms > 0 ? ChatFormatting.GREEN : ChatFormatting.GRAY;
        MutableComponent storedComponent = Component.literal((String)String.valueOf(storedBrooms)).withStyle(storedColor);
        source.sendSuccess(() -> BroomCommand.lambda$executeStatsForPlayer$37((Component)storedComponent), false);
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.stats.summon_section"), false);
        MutableComponent nearbyStatus = (Boolean)Config.ENABLE_NEARBY_SUMMON.get() != false ? Component.translatable((String)"command.ashenwitchbroom.broom.stats.enabled") : Component.translatable((String)"command.ashenwitchbroom.broom.stats.disabled");
        MutableComponent worldStatus = (Boolean)Config.ENABLE_WORLD_SUMMON.get() != false ? Component.translatable((String)"command.ashenwitchbroom.broom.stats.enabled") : Component.translatable((String)"command.ashenwitchbroom.broom.stats.disabled");
        MutableComponent crossDimensionStatus = (Boolean)Config.ENABLE_CROSS_DIMENSION_SUMMON.get() != false ? Component.translatable((String)"command.ashenwitchbroom.broom.stats.enabled") : Component.translatable((String)"command.ashenwitchbroom.broom.stats.disabled");
        MutableComponent inventoryStatus = (Boolean)Config.ENABLE_INVENTORY_SUMMON.get() != false ? Component.translatable((String)"command.ashenwitchbroom.broom.stats.enabled") : Component.translatable((String)"command.ashenwitchbroom.broom.stats.disabled");
        source.sendSuccess(() -> BroomCommand.lambda$executeStatsForPlayer$40((Component)nearbyStatus), false);
        source.sendSuccess(() -> BroomCommand.lambda$executeStatsForPlayer$41((Component)worldStatus), false);
        source.sendSuccess(() -> BroomCommand.lambda$executeStatsForPlayer$42((Component)crossDimensionStatus), false);
        source.sendSuccess(() -> BroomCommand.lambda$executeStatsForPlayer$43((Component)inventoryStatus), false);
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
        return 1;
    }

    private static int executeCleanup(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return BroomCommand.executeCleanupForPlayer(source, player);
        }
        source.sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.player_only"));
        return 0;
    }

    private static int executeCleanupPlayer(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            ServerPlayer targetPlayer = EntityArgument.getPlayer(context, (String)"player");
            return BroomCommand.executeCleanupForPlayer(source, targetPlayer);
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.translatable((String)"commands.broom.cleanup.player_not_found"));
            return 0;
        }
    }

    private static int executeCleanupForPlayer(CommandSourceStack source, ServerPlayer player) {
        UUID playerUUID;
        ServerLevel level = player.serverLevel();
        List<BroomData> brooms = BroomDataManager.loadPlayerBrooms(level, playerUUID = player.getUUID());
        if (brooms.isEmpty()) {
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.result_title"), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.player_info", (Object[])new Object[]{player.getDisplayName().getString()}), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.no_brooms_status"), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
            return 1;
        }
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.progress_title"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
        ChatFormatting broomCountColor = brooms.size() > 10 ? ChatFormatting.GREEN : (brooms.size() > 5 ? ChatFormatting.YELLOW : ChatFormatting.WHITE);
        MutableComponent broomCountComponent = Component.literal((String)String.valueOf(brooms.size())).withStyle(broomCountColor);
        source.sendSuccess(() -> BroomCommand.lambda$executeCleanupForPlayer$53(player, (Component)broomCountComponent), false);
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.start_verify"), false);
        AtomicInteger removedCount = new AtomicInteger(0);
        AtomicInteger totalCount = new AtomicInteger(brooms.size());
        ArrayList removedBrooms = new ArrayList();
        CompletionStage<Object> cleanupFuture = CompletableFuture.completedFuture(null);
        for (BroomData broom : brooms) {
            cleanupFuture = cleanupFuture.thenCompose(v -> BroomCommand.verifyBroomExistsByUUID(player, broom).thenAccept(exists -> {
                if (!exists.booleanValue()) {
                    boolean removed = BroomCommand.removeBroomByUUID(level, playerUUID, broom);
                    if (removed) {
                        removedCount.incrementAndGet();
                        removedBrooms.add(broom.getBroomName());
                        level.getServer().execute(() -> source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.invalid_removed", (Object[])new Object[]{broom.getBroomName()}), false));
                    }
                } else {
                    level.getServer().execute(() -> source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.valid", (Object[])new Object[]{broom.getBroomName()}), false));
                }
            }));
        }
        ((CompletableFuture)cleanupFuture.thenRun(() -> level.getServer().execute(() -> {
            int removed = removedCount.get();
            int remaining = totalCount.get() - removed;
            source.sendSuccess(() -> Component.literal((String)""), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.result_section"), false);
            ChatFormatting totalColor = totalCount.get() > 10 ? ChatFormatting.GREEN : (totalCount.get() > 5 ? ChatFormatting.YELLOW : ChatFormatting.WHITE);
            MutableComponent totalComponent = Component.literal((String)String.valueOf(totalCount.get())).withStyle(totalColor);
            source.sendSuccess(() -> BroomCommand.lambda$executeCleanupForPlayer$64((Component)totalComponent), false);
            ChatFormatting validColor = remaining > 0 ? ChatFormatting.GREEN : ChatFormatting.GRAY;
            MutableComponent validComponent = Component.literal((String)String.valueOf(remaining)).withStyle(validColor);
            source.sendSuccess(() -> BroomCommand.lambda$executeCleanupForPlayer$65((Component)validComponent), false);
            ChatFormatting removedColor = removed > 0 ? ChatFormatting.RED : ChatFormatting.GRAY;
            MutableComponent removedComponent = Component.literal((String)String.valueOf(removed)).withStyle(removedColor);
            source.sendSuccess(() -> BroomCommand.lambda$executeCleanupForPlayer$66((Component)removedComponent), false);
            source.sendSuccess(() -> Component.literal((String)""), false);
            if (removed > 0) {
                MutableComponent removedCountComponent = Component.literal((String)String.valueOf(removed)).withStyle(ChatFormatting.RED);
                source.sendSuccess(() -> BroomCommand.lambda$executeCleanupForPlayer$68((Component)removedCountComponent), false);
            } else {
                source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.success_all_valid"), false);
            }
            source.sendSuccess(() -> Component.literal((String)""), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
        }))).exceptionally(throwable -> {
            level.getServer().execute(() -> {
                source.sendSuccess(() -> Component.literal((String)""), false);
                source.sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.error", (Object[])new Object[]{throwable.getMessage()}));
                source.sendSuccess(() -> Component.literal((String)""), false);
                source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
            });
            return null;
        });
        return 1;
    }

    private static CompletableFuture<Boolean> verifyBroomExistsByUUID(ServerPlayer player, BroomData broomData) {
        if (broomData.getEntityUUID() == null) {
            return CompletableFuture.completedFuture(false);
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                ServerLevel targetLevel = player.getServer().getLevel(broomData.getDimension());
                if (targetLevel == null) {
                    return false;
                }
                BlockPos broomPos = broomData.getPosition();
                targetLevel.getChunk(broomPos);
                Entity entity = targetLevel.getEntity(broomData.getEntityUUID());
                if (entity instanceof MajoBroomEntity) {
                    MajoBroomEntity broomEntity = (MajoBroomEntity)entity;
                    return broomData.getBroomName().equals(broomEntity.getBroomName()) && player.getUUID().equals(broomEntity.getOwnerUUID());
                }
                return false;
            }
            catch (Exception e) {
                AshenWitchBroom.LOGGER.warn("Error verifying broom existence: {}", (Object)e.getMessage());
                return false;
            }
        });
    }

    private static boolean removeBroomByUUID(ServerLevel level, UUID playerUUID, BroomData broomToRemove) {
        List<BroomData> brooms = BroomDataManager.loadPlayerBrooms(level, playerUUID);
        boolean removed = brooms.removeIf(broom -> broom.getBroomName().equals(broomToRemove.getBroomName()) && broom.getEntityUUID() != null && broom.getEntityUUID().equals(broomToRemove.getEntityUUID()));
        if (removed) {
            BroomDataManager.savePlayerBrooms(level, playerUUID, brooms);
            AshenWitchBroom.LOGGER.info("Removed broom '{}' with UUID {} for player {}", new Object[]{broomToRemove.getBroomName(), broomToRemove.getEntityUUID(), playerUUID});
        }
        return removed;
    }

    private static int executeHelp(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        boolean isOp = source.hasPermission(2);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.title"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.player_commands"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.detect_self"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.stats_self"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.cleanup_self"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.help_command"), false);
        if (isOp) {
            source.sendSuccess(() -> Component.literal((String)""), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.admin_commands"), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.detect_player"), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.stats_player"), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.cleanup_player"), false);
        }
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.usage_tips"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.tip_self_manage"), false);
        if (!isOp) {
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.tip_op_required"), false);
        }
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.tip_cleanup"), false);
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
        return 1;
    }

    private static /* synthetic */ Component lambda$executeCleanupForPlayer$68(Component removedCountComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.success_with_removed", (Object[])new Object[]{removedCountComponent});
    }

    private static /* synthetic */ Component lambda$executeCleanupForPlayer$66(Component removedComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.cleaned_brooms", (Object[])new Object[]{removedComponent});
    }

    private static /* synthetic */ Component lambda$executeCleanupForPlayer$65(Component validComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.valid_brooms", (Object[])new Object[]{validComponent});
    }

    private static /* synthetic */ Component lambda$executeCleanupForPlayer$64(Component totalComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.total_brooms", (Object[])new Object[]{totalComponent});
    }

    private static /* synthetic */ Component lambda$executeCleanupForPlayer$53(ServerPlayer player, Component broomCountComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.player_broom_count", (Object[])new Object[]{player.getDisplayName().getString(), broomCountComponent});
    }

    private static /* synthetic */ Component lambda$executeStatsForPlayer$43(Component inventoryStatus) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.stats.inventory_summon", (Object[])new Object[]{inventoryStatus.getString()});
    }

    private static /* synthetic */ Component lambda$executeStatsForPlayer$42(Component crossDimensionStatus) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.stats.cross_dimension_summon", (Object[])new Object[]{crossDimensionStatus.getString()});
    }

    private static /* synthetic */ Component lambda$executeStatsForPlayer$41(Component worldStatus) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.stats.world_summon", (Object[])new Object[]{worldStatus.getString()});
    }

    private static /* synthetic */ Component lambda$executeStatsForPlayer$40(Component nearbyStatus) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.stats.nearby_summon", (Object[])new Object[]{nearbyStatus.getString()});
    }

    private static /* synthetic */ Component lambda$executeStatsForPlayer$37(Component storedComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.stats.stored", (Object[])new Object[]{storedComponent});
    }

    private static /* synthetic */ Component lambda$executeStatsForPlayer$36(String dimensionName, Component currentDimensionComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.stats.current_dimension", (Object[])new Object[]{dimensionName, currentDimensionComponent});
    }

    private static /* synthetic */ Component lambda$executeStatsForPlayer$35(int nearbyRange, Component nearbyComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.stats.nearby", (Object[])new Object[]{nearbyRange, nearbyComponent});
    }

    private static /* synthetic */ Component lambda$executeStatsForPlayer$34(Component inventoryComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.stats.inventory", (Object[])new Object[]{inventoryComponent});
    }

    private static /* synthetic */ Component lambda$executeStatsForPlayer$33(Component totalComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.stats.total", (Object[])new Object[]{totalComponent});
    }

    private static /* synthetic */ Component lambda$executeDetectForPlayer$20(Component distanceComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.detect.distance", (Object[])new Object[]{distanceComponent});
    }

    private static /* synthetic */ Component lambda$executeDetectForPlayer$12(Component indexComponent, BroomData broom) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.detect.broom_index", (Object[])new Object[]{indexComponent, broom.getBroomName()});
    }

    private static /* synthetic */ Component lambda$executeDetectForPlayer$10(ServerPlayer player, Component broomCountComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.detect.player_count", (Object[])new Object[]{player.getDisplayName().getString(), broomCountComponent});
    }
}

