/*
 * Decompiled with CFR 0.152.
 */
package com.magicbroom.examplemod.data;

import com.magicbroom.examplemod.core.AshenWitchBroom;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class BroomData {
    private String broomName;
    private ResourceKey<Level> dimension;
    private BlockPos position;
    private UUID entityUUID;

    public BroomData(String broomName, ResourceKey<Level> dimension, BlockPos position) {
        this.broomName = broomName;
        this.dimension = dimension;
        this.position = position;
        this.entityUUID = null;
    }

    public BroomData(String broomName, ResourceKey<Level> dimension, BlockPos position, UUID entityUUID) {
        this.broomName = broomName;
        this.dimension = dimension;
        this.position = position;
        this.entityUUID = entityUUID;
    }

    public static BroomData fromNBT(CompoundTag tag) {
        String broomName = tag.getString("broomName");
        String dimensionStr = tag.getString("dimension");
        BlockPos position = new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
        ResourceKey dimension = Level.OVERWORLD;
        if ("minecraft:the_nether".equals(dimensionStr)) {
            dimension = Level.NETHER;
        } else if ("minecraft:the_end".equals(dimensionStr)) {
            dimension = Level.END;
        } else if ("minecraft:overworld".equals(dimensionStr)) {
            dimension = Level.OVERWORLD;
        }
        UUID entityUUID = null;
        if (tag.contains("entityUUID", 8)) {
            try {
                entityUUID = UUID.fromString(tag.getString("entityUUID"));
            }
            catch (IllegalArgumentException e) {
                AshenWitchBroom.LOGGER.warn("Invalid entityUUID in broom data: {}", (Object)tag.getString("entityUUID"));
            }
        }
        if (entityUUID == null) {
            AshenWitchBroom.LOGGER.warn("Broom data missing required entityUUID, this data will be invalid");
        }
        return new BroomData(broomName, (ResourceKey<Level>)dimension, position, entityUUID);
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putString("broomName", this.broomName);
        tag.putString("dimension", this.dimension.location().toString());
        tag.putInt("x", this.position.getX());
        tag.putInt("y", this.position.getY());
        tag.putInt("z", this.position.getZ());
        if (this.entityUUID != null) {
            tag.putString("entityUUID", this.entityUUID.toString());
        }
        return tag;
    }

    public double getDistanceSquared(BlockPos playerPos, ResourceKey<Level> playerDimension) {
        if (!this.dimension.equals(playerDimension)) {
            return Double.MAX_VALUE;
        }
        double dx = this.position.getX() - playerPos.getX();
        double dy = this.position.getY() - playerPos.getY();
        double dz = this.position.getZ() - playerPos.getZ();
        return dx * dx + dy * dy + dz * dz;
    }

    public String getBroomName() {
        return this.broomName;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public UUID getEntityUUID() {
        return this.entityUUID;
    }

    public void setBroomName(String broomName) {
        this.broomName = broomName;
    }

    public void setDimension(ResourceKey<Level> dimension) {
        this.dimension = dimension;
    }

    public void setPosition(BlockPos position) {
        this.position = position;
    }

    public void setEntityUUID(UUID entityUUID) {
        this.entityUUID = entityUUID;
    }

    public String toString() {
        return String.format("BroomData{name='%s', dimension='%s', pos=%s, entityUUID=%s}", this.broomName, this.dimension.location().toString(), this.position.toString(), this.entityUUID);
    }
}

