/*
 * Decompiled with CFR 0.152.
 */
package com.magicbroom.examplemod.service;

import com.magicbroom.examplemod.core.AshenWitchBroom;
import com.magicbroom.examplemod.core.Config;
import com.magicbroom.examplemod.data.BroomData;
import com.magicbroom.examplemod.data.BroomDataManager;
import com.magicbroom.examplemod.entity.MajoBroomEntity;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class BroomSummonService {
    private static final ConcurrentHashMap<UUID, ReentrantLock> playerLocks = new ConcurrentHashMap();

    public static void summonBroom(ServerPlayer player, double x, double y, double z) {
        UUID playerUUID = player.getUUID();
        ReentrantLock playerLock = playerLocks.computeIfAbsent(playerUUID, k -> new ReentrantLock());
        if (!playerLock.tryLock()) {
            AshenWitchBroom.LOGGER.debug("Player {} summon request ignored - previous operation still in progress", (Object)playerUUID);
            return;
        }
        try {
            if (player.isPassenger() && player.getVehicle() instanceof MajoBroomEntity) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.already_riding"));
                return;
            }
            ServerLevel level = player.serverLevel();
            BlockPos playerPos = player.blockPosition();
            ResourceKey playerDimension = level.dimension();
            List<BroomData> playerBrooms = BroomDataManager.loadPlayerBrooms(level, playerUUID);
            CompletableFuture<String> summonFuture = BroomSummonService.findBestBroomToSummon(level, player, playerBrooms, playerPos, (ResourceKey<Level>)playerDimension);
            ((CompletableFuture)summonFuture.thenAccept(broomName -> level.getServer().execute(() -> {
                try {
                    if (broomName != null) {
                        BroomSummonService.executeBroomSummon(player, broomName, playerPos, (ResourceKey<Level>)playerDimension);
                    } else {
                        player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.no_broom_available"));
                        if (((Boolean)Config.ENABLE_DETAILED_INFO.get()).booleanValue()) {
                            BroomSummonService.showBroomSummary(player, playerBrooms);
                        }
                    }
                }
                finally {
                    playerLock.unlock();
                }
            }))).exceptionally(throwable -> {
                level.getServer().execute(() -> playerLock.unlock());
                AshenWitchBroom.LOGGER.error("Error during broom summon for player {}: {}", (Object)playerUUID, (Object)throwable.getMessage());
                return null;
            });
        }
        catch (Exception e) {
            playerLock.unlock();
            AshenWitchBroom.LOGGER.error("Error in summonBroom for player {}: {}", (Object)playerUUID, (Object)e.getMessage());
            throw e;
        }
    }

    private static CompletableFuture<String> findBestBroomToSummon(ServerLevel level, ServerPlayer player, List<BroomData> playerBrooms, BlockPos playerPos, ResourceKey<Level> playerDimension) {
        ItemStack broomItem;
        ArrayList<BroomData> candidateBrooms = new ArrayList<BroomData>();
        if (((Boolean)Config.ENABLE_NEARBY_SUMMON.get()).booleanValue()) {
            int searchRange = (Integer)Config.NEARBY_SEARCH_RANGE.get();
            List<BroomData> nearbyBrooms = BroomSummonService.filterBroomsByDistance(playerBrooms, playerPos, playerDimension, searchRange);
            candidateBrooms.addAll(nearbyBrooms);
        }
        if (((Boolean)Config.ENABLE_WORLD_SUMMON.get()).booleanValue() && candidateBrooms.isEmpty()) {
            List<BroomData> worldBrooms = BroomSummonService.filterBroomsByDimension(playerBrooms, playerDimension);
            candidateBrooms.addAll(worldBrooms);
        }
        if (((Boolean)Config.ENABLE_CROSS_DIMENSION_SUMMON.get()).booleanValue() && candidateBrooms.isEmpty()) {
            candidateBrooms.addAll(playerBrooms);
        }
        if (candidateBrooms.isEmpty() && ((Boolean)Config.ENABLE_INVENTORY_SUMMON.get()).booleanValue() && (broomItem = BroomSummonService.findBroomInInventory(player)) != null) {
            return CompletableFuture.completedFuture("FROM_INVENTORY");
        }
        if (candidateBrooms.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        candidateBrooms.sort(Comparator.comparingDouble(broom -> broom.getDistanceSquared(playerPos, playerDimension)));
        return BroomSummonService.verifyBroomsSequentially(player, candidateBrooms, 0);
    }

    private static List<BroomData> filterBroomsByDistance(List<BroomData> brooms, BlockPos playerPos, ResourceKey<Level> playerDimension, int maxDistance) {
        ArrayList<BroomData> filtered = new ArrayList<BroomData>();
        double maxDistanceSquared = maxDistance * maxDistance;
        for (BroomData broom : brooms) {
            double distanceSquared;
            if (!broom.getDimension().equals(playerDimension) || !((distanceSquared = broom.getDistanceSquared(playerPos, playerDimension)) <= maxDistanceSquared)) continue;
            filtered.add(broom);
        }
        return filtered;
    }

    private static List<BroomData> filterBroomsByDimension(List<BroomData> brooms, ResourceKey<Level> dimension) {
        ArrayList<BroomData> filtered = new ArrayList<BroomData>();
        for (BroomData broom : brooms) {
            if (!broom.getDimension().equals(dimension)) continue;
            filtered.add(broom);
        }
        return filtered;
    }

    private static CompletableFuture<String> verifyBroomsSequentially(ServerPlayer player, List<BroomData> brooms, int index) {
        if (index >= brooms.size()) {
            return CompletableFuture.completedFuture(null);
        }
        BroomData currentBroom = brooms.get(index);
        return BroomDataManager.verifyBroomExists(player, currentBroom.getBroomName()).thenCompose(exists -> {
            if (exists.booleanValue()) {
                return CompletableFuture.completedFuture(currentBroom.getBroomName());
            }
            BroomDataManager.removeBroom(player.serverLevel(), player.getUUID(), currentBroom.getBroomName());
            return BroomSummonService.verifyBroomsSequentially(player, brooms, index + 1);
        });
    }

    private static void executeBroomSummon(ServerPlayer player, String broomName, BlockPos playerPos, ResourceKey<Level> playerDimension) {
        ServerLevel level = player.serverLevel();
        if ("FROM_INVENTORY".equals(broomName)) {
            BroomSummonService.summonFromInventory(player, playerPos);
            return;
        }
        BroomData broomData = BroomDataManager.findBroom(level, player.getUUID(), broomName);
        if (broomData != null) {
            boolean isCrossDimension;
            BroomSummonService.removeOldBroomEntity(player, broomData);
            boolean bl = isCrossDimension = !broomData.getDimension().equals(playerDimension);
            if (isCrossDimension) {
                BroomDataManager.removeBroom(level, player.getUUID(), broomName);
                newBroom = new MajoBroomEntity((EntityType)AshenWitchBroom.MAJO_BROOM_ENTITY.get(), (Level)level);
                newBroom.setPos((double)playerPos.getX() + 0.5, playerPos.getY(), (double)playerPos.getZ() + 0.5);
                newBroom.setYRot(player.getYRot());
                newBroom.setBroomInfo(broomName, player.getUUID());
                level.addFreshEntity((Entity)newBroom);
                BroomDataManager.addBroom(level, player.getUUID(), broomName, playerDimension, playerPos, newBroom.getUUID());
                AshenWitchBroom.LOGGER.info("Cross-dimension summon: broom '{}' moved from {} to {} for player {}", new Object[]{broomName, broomData.getDimension().location(), playerDimension.location(), player.getUUID()});
            } else {
                newBroom = new MajoBroomEntity((EntityType)AshenWitchBroom.MAJO_BROOM_ENTITY.get(), (Level)level);
                newBroom.setPos((double)playerPos.getX() + 0.5, playerPos.getY(), (double)playerPos.getZ() + 0.5);
                newBroom.setYRot(player.getYRot());
                newBroom.setBroomInfo(broomName, player.getUUID());
                level.addFreshEntity((Entity)newBroom);
                BroomDataManager.updateBroom(level, player.getUUID(), broomName, playerDimension, playerPos, newBroom.getUUID());
            }
            player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.broom_summoned", (Object[])new Object[]{broomName}));
            if (((Boolean)Config.ENABLE_DETAILED_INFO.get()).booleanValue()) {
                List<BroomData> allBrooms = BroomDataManager.loadPlayerBrooms(level, player.getUUID());
                BroomSummonService.showBroomSummary(player, allBrooms);
            }
        }
    }

    private static void removeOldBroomEntity(ServerPlayer player, BroomData broomData) {
        ServerLevel targetLevel = player.getServer().getLevel(broomData.getDimension());
        if (targetLevel == null) {
            return;
        }
        UUID targetEntityUUID = broomData.getEntityUUID();
        if (targetEntityUUID == null) {
            AshenWitchBroom.LOGGER.warn("Cannot remove broom '{}' - no entityUUID available", (Object)broomData.getBroomName());
            return;
        }
        BlockPos broomPos = broomData.getPosition();
        ChunkPos centerChunk = new ChunkPos(broomPos);
        ArrayList<ChunkPos> chunksToLoad = new ArrayList<ChunkPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                chunksToLoad.add(new ChunkPos(centerChunk.x + x, centerChunk.z + z));
            }
        }
        for (ChunkPos chunkPos : chunksToLoad) {
            targetLevel.getChunk(chunkPos.x, chunkPos.z);
        }
        Entity targetEntity = targetLevel.getEntity(targetEntityUUID);
        if (targetEntity instanceof MajoBroomEntity) {
            MajoBroomEntity broomEntity = (MajoBroomEntity)targetEntity;
            if (broomData.getBroomName().equals(broomEntity.getBroomName()) && player.getUUID().equals(broomEntity.getOwnerUUID())) {
                targetEntity.discard();
                AshenWitchBroom.LOGGER.info("Removed broom entity '{}' with UUID {} for player {}", new Object[]{broomData.getBroomName(), targetEntityUUID, player.getUUID()});
            } else {
                AshenWitchBroom.LOGGER.warn("Broom entity UUID {} found but name/owner mismatch. Expected: {}/{}, Found: {}/{}", new Object[]{targetEntityUUID, broomData.getBroomName(), player.getUUID(), broomEntity.getBroomName(), broomEntity.getOwnerUUID()});
            }
        } else {
            AshenWitchBroom.LOGGER.debug("Broom entity with UUID {} not found after chunk loading", (Object)targetEntityUUID);
        }
    }

    private static void summonFromInventory(ServerPlayer player, BlockPos playerPos) {
        ItemStack broomItem = BroomSummonService.findBroomInInventory(player);
        if (broomItem != null) {
            ServerLevel level = player.serverLevel();
            String broomName = BroomDataManager.generateUniqueBroomName(level, player.getUUID());
            MajoBroomEntity broomEntity = new MajoBroomEntity((EntityType)AshenWitchBroom.MAJO_BROOM_ENTITY.get(), (Level)level);
            broomEntity.setPos((double)playerPos.getX() + 0.5, playerPos.getY(), (double)playerPos.getZ() + 0.5);
            broomEntity.setYRot(player.getYRot());
            broomEntity.setBroomInfo(broomName, player.getUUID());
            level.addFreshEntity((Entity)broomEntity);
            if (!player.getAbilities().instabuild) {
                broomItem.shrink(1);
            }
            BroomDataManager.addBroom(level, player.getUUID(), broomName, (ResourceKey<Level>)level.dimension(), playerPos, broomEntity.getUUID());
            player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.broom_summoned_from_inventory", (Object[])new Object[]{broomName}));
            if (((Boolean)Config.ENABLE_DETAILED_INFO.get()).booleanValue()) {
                List<BroomData> allBrooms = BroomDataManager.loadPlayerBrooms(level, player.getUUID());
                BroomSummonService.showBroomSummary(player, allBrooms);
            }
        }
    }

    private static ItemStack findBroomInInventory(ServerPlayer player) {
        for (ItemStack itemStack : player.getInventory().items) {
            if (itemStack.getItem() != AshenWitchBroom.MAJO_BROOM_ITEM.get()) continue;
            return itemStack;
        }
        return null;
    }

    private static void showBroomSummary(ServerPlayer player, List<BroomData> brooms) {
        int storedBrooms = brooms.size();
        int inventoryBrooms = 0;
        for (ItemStack itemStack : player.getInventory().items) {
            if (itemStack.getItem() != AshenWitchBroom.MAJO_BROOM_ITEM.get()) continue;
            inventoryBrooms += itemStack.getCount();
        }
        int totalBrooms = storedBrooms + inventoryBrooms;
        ResourceKey currentDimension = player.level().dimension();
        long currentDimensionBrooms = brooms.stream().filter(broom -> broom.getDimension().equals((Object)currentDimension)).count();
        long allDimensionBrooms = brooms.size();
        int nearbyRange = (Integer)Config.NEARBY_SEARCH_RANGE.get();
        BlockPos playerPos = player.blockPosition();
        long nearbyBrooms = brooms.stream().filter(broom -> broom.getDimension().equals((Object)currentDimension)).filter(broom -> broom.getDistanceSquared(playerPos, (ResourceKey<Level>)currentDimension) <= (double)(nearbyRange * nearbyRange)).count();
        player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.broom_summary_total", (Object[])new Object[]{totalBrooms}));
        player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.broom_summary_inventory", (Object[])new Object[]{inventoryBrooms}));
        player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.broom_summary_nearby", (Object[])new Object[]{nearbyRange, nearbyBrooms}));
        player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.broom_summary_current_world", (Object[])new Object[]{currentDimensionBrooms}));
        player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.broom_summary_all_dimensions", (Object[])new Object[]{allDimensionBrooms}));
        String nearbyStatus = (Boolean)Config.ENABLE_NEARBY_SUMMON.get() != false ? "\u2714" : "\u00d7";
        String worldStatus = (Boolean)Config.ENABLE_WORLD_SUMMON.get() != false ? "\u2714" : "\u00d7";
        String crossDimensionStatus = (Boolean)Config.ENABLE_CROSS_DIMENSION_SUMMON.get() != false ? "\u2714" : "\u00d7";
        String inventoryStatus = (Boolean)Config.ENABLE_INVENTORY_SUMMON.get() != false ? "\u2714" : "\u00d7";
        player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.summon_order_status", (Object[])new Object[]{nearbyStatus, worldStatus, crossDimensionStatus, inventoryStatus}));
    }
}

