package me.alexdevs.solstice.core.coreModule.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.core.coreModule.CoreModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import java.util.List;
import java.util.Map;

public class PingCommand extends ModCommand<CoreModule> {
    public PingCommand(CoreModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("ping");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return class_2170.method_9247(name)
                .requires(require("ping.base", true))
                .executes(context -> {
                    var player = context.getSource().method_9207();
                    var ping = player.field_13987.method_52405();
                    var map = Map.of(
                            "ping", class_2561.method_30163(String.valueOf(ping))
                    );
                    context.getSource().method_9226(() -> module.locale().get("ping.self", map), false);
                    return 1;
                })
                .then(class_2170.method_9244("player", class_2186.method_9305())
                        .requires(require("ping.others", 1))
                        .executes(context -> {
                            var player = class_2186.method_9315(context, "player");
                            var ping = player.field_13987.method_52405();
                            var map = Map.of(
                                    "ping", class_2561.method_30163(String.valueOf(ping)),
                                    "player", player.method_5477()
                            );
                            context.getSource().method_9226(() -> module.locale().get("ping.other", map), false);
                            return 1;
                        })
                );
    }
}
