package me.alexdevs.solstice.core.coreModule.commands;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.command.LocalGameProfile;
import me.alexdevs.solstice.api.events.SolsticeEvents;
import me.alexdevs.solstice.api.module.Debug;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.api.text.Format;
import me.alexdevs.solstice.core.coreModule.CoreModule;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_155;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class SolsticeCommand extends ModCommand<CoreModule> {
    public SolsticeCommand(CoreModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("solstice", "sol");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(true))
                .executes(context -> {
                    var modContainer = FabricLoader.getInstance().getModContainer(Solstice.MOD_ID).orElse(null);
                    if (modContainer == null) {
                        context.getSource().method_9226(() -> class_2561.method_30163("Could not find self in mod list???"), false);
                        return 1;
                    }

                    var metadata = modContainer.getMetadata();
                    var placeholders = Map.of(
                            "name", class_2561.method_30163(metadata.getName()),
                            "version", class_2561.method_30163(metadata.getVersion().getFriendlyString())
                    );

                    var text = Format.parse(
                            "<gold>${name} v${version}</gold>",
                            placeholders);
                    context.getSource().method_9226(() -> text, false);

                    return 1;
                })
                .then(method_9247("reload")
                        .requires(require("reload", 3))
                        .executes(context -> {
                            try {
                                Solstice.configManager.load();
                                Solstice.localeManager.reload();
                            } catch (Exception e) {
                                Solstice.LOGGER.error("Failed to reload Solstice", e);
                                context.getSource().method_9226(() -> class_2561.method_30163("Failed to load Solstice config. Check console for more info."), true);
                                return 1;
                            }

                            SolsticeEvents.RELOAD.invoker().onReload(Solstice.getInstance());

                            context.getSource().method_9226(() -> class_2561.method_30163("Reloaded Solstice config"), true);

                            return 1;
                        }))
                .then(method_9247("reloaduser")
                        .requires(require("reloaduser", 3))
                        .then(method_9244("player", StringArgumentType.word())
                                .suggests(LocalGameProfile::suggest)
                                .executes(context -> {
                                    var profile = LocalGameProfile.getProfile(context, "player");

                                    context.getSource().method_9226(() -> class_2561.method_30163("Force reloading player data for " + profile.getName()), true);

                                    Solstice.playerData.forceLoad(profile.getId());
                                    return 0;
                                })))
                .then(method_9247("debug")
                        .requires(require("debug", 4))
                        .then(method_9247("gen-command-list")
                                .executes(context -> {
                                    var builder = new StringBuilder();

                                    var list = new ArrayList<>(Debug.commandDebugList);

                                    list.sort(Comparator.comparing(Debug.CommandDebug::module));

                                    builder.append(String.format("| %s | %s | %s | %s |\n", "Module", "Command", "Aliases", "Permission"));
                                    builder.append("|---|---|---|---|\n");
                                    for (var command : list) {
                                        builder.append(String.format("| %s | %s | %s | %s |\n", command.module(), command.command(), String.join(" ", command.commands()), command.permission()));
                                    }

                                    var output = builder.toString();

                                    var file = FabricLoader.getInstance().getGameDir().resolve("solstice-commands.md").toFile();
                                    try (var fw = new FileWriter(file)) {
                                        fw.write(output);
                                    } catch (IOException e) {
                                        throw new SimpleCommandExceptionType(class_2561.method_30163(e.getMessage())).create();
                                    }

                                    context.getSource().method_9226(() -> class_2561.method_30163("Generated 'solstice-commands.md'"), true);

                                    return 1;
                                }))
                        .then(method_9247("tags")
                                .executes(context -> {
                                    var player = context.getSource().method_9207();

                                    var hand = player.method_6058();
                                    var itemStack = player.method_5998(hand);

                                    var entry = itemStack.method_41409().method_40230().get();
                                    var entryString = String.format("Tags for [%s / %s]:", entry.method_41185(), entry.method_29177());

                                    var text = class_2561.method_43473();
                                    text.method_10852(class_2561.method_30163(entryString));
                                    var tags = itemStack.method_40133().iterator();
                                    while (tags.hasNext()) {
                                        var tag = tags.next();
                                        text.method_10852(class_2561.method_30163("\n"));
                                        text.method_10852(
                                                class_2561.method_43470(" #" + tag.comp_327())
                                                        .method_10862(class_2583.field_24360
                                                                .method_10949(new class_2568(class_2568.class_5247.field_24342, class_2561.method_30163("Click to copy")))
                                                                .method_10958(new class_2558(class_2558.class_2559.field_21462, "#" + tag.comp_327()))
                                                        )
                                        );
                                    }

                                    context.getSource().method_9226(() -> text, false);

                                    return 1;
                                }))
                        .then(class_2170.method_9247("enable")
                                .then(class_2170.method_9244("enable", BoolArgumentType.bool())
                                        .requires(require("debug.enable", 4))
                                        .executes(context -> {
                                            var enable = BoolArgumentType.getBool(context, "enable");

                                            // Command exception stack traces are not printed anywhere unless this variable is true.
                                            // Unfortunately, this flag also causes other effects that WILL crash the server, i.e., /reload.
                                            class_155.field_1125 = enable;

                                            if (enable) {
                                                var message = notice("<red><obf>!</obf> WARNING <obf>!</obf></red> <yellow>Debug mode has been enabled. This state may result in instabilities!</yellow>");
                                                context.getSource().method_9226(() -> message, true);
                                            } else {
                                                var message = notice("Debug mode has been disabled");
                                                context.getSource().method_9226(() -> message, true);
                                            }

                                            return 1;
                                        })
                                ))
                );
    }

    private static class_2561 notice(String text) {
        return Format.parse("[<gold>Solstice</gold>] " + text);
    }
}
