package me.alexdevs.solstice.mixin.events;

import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.events.WorldSaveCallback;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(MinecraftServer.class)
public class WorldSaveEventMixin {
    @Inject(method = "saveEverything", at = @At("TAIL"))
    public void save(boolean suppressLogs, boolean flush, boolean force, CallbackInfoReturnable<Boolean> cir) {
        try {
            WorldSaveCallback.EVENT.invoker().onSave((MinecraftServer) (Object) this, suppressLogs, flush, force);
        } catch (Exception e) {
            Solstice.LOGGER.error("Exception emitting world save event", e);
        }
    }
}
