package me.alexdevs.solstice.mixin.modules.spawn;

import me.alexdevs.solstice.modules.ModuleProvider;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_5454;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_3222.class)
public abstract class OverrideSpawnPointMixin {
    @Shadow
    @Final
    public MinecraftServer server;

    @Shadow
    private class_2338 respawnPosition;

    @Inject(method = "findRespawnPositionAndUseSpawnBlock", at = @At("RETURN"), cancellable = true)
    public void solstice$overrideRespawnTarget(boolean keepInventory, class_5454.class_9823 postDimensionTransition, CallbackInfoReturnable<class_5454> cir) {
        var spawnModule = ModuleProvider.SPAWN;
        var config = spawnModule.getConfig();

        var spawn = spawnModule.getGlobalSpawnPosition();
        var world = spawn.getWorld(this.server);
        var pos = new class_243(
                spawn.getX(),
                spawn.getY(),
                spawn.getZ()
        );

        var transition = new class_5454(
                world,
                pos,
                class_243.field_1353,
                spawn.getYaw(),
                spawn.getPitch(),
                false,
                class_5454.field_52245
        );

        if (config.globalSpawn.onRespawn) {
            cir.setReturnValue(transition);
            return;
        }

        if(config.globalSpawn.onRespawnSoft && respawnPosition == null) {
            cir.setReturnValue(transition);
        }
    }
}
