package me.alexdevs.solstice.modules.ban.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.api.module.Utils;
import me.alexdevs.solstice.api.text.Format;
import me.alexdevs.solstice.modules.ban.BanModule;
import me.alexdevs.solstice.modules.ban.formatters.BanMessageFormatter;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3336;
import net.minecraft.class_7157;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.Date;
import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class BanCommand extends ModCommand<BanModule> {
    public static final SimpleCommandExceptionType ALREADY_BANNED_EXCEPTION = new SimpleCommandExceptionType(class_2561.method_43471("commands.ban.failed"));

    public BanCommand(BanModule module) {
        super(module);
    }

    static int execute(CommandContext<class_2168> context, Collection<GameProfile> targets, @Nullable String reason, @Nullable Date expiryDate) throws CommandSyntaxException {
        var source = context.getSource();
        var server = source.method_9211();
        var banList = server.method_3760().method_14563();

        var banCounter = 0;
        for (GameProfile target : targets) {
            if (banList.method_14650(target)) {
                continue;
            }

            var banEntry = new class_3336(target, null, source.method_9214(), expiryDate, reason);
            banList.method_14633(banEntry);
            banCounter++;

            var playerContext = PlaceholderContext.of(target, server);

            source.method_9226(() -> class_2561.method_43469("commands.ban.success", class_2561.method_30163(target.getName()), Format.parse(banEntry.method_14503(), playerContext)), true);

            var serverPlayerEntity = source.method_9211().method_3760().method_14602(target.getId());
            if (serverPlayerEntity != null) {
                serverPlayerEntity.field_13987.method_52396(BanMessageFormatter.format(target, banEntry));
            }
        }

        if (banCounter == 0) {
            throw ALREADY_BANNED_EXCEPTION.create();
        } else {
            return banCounter;
        }
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistry, class_2170.class_5364 environment) {
        Utils.removeCommands(dispatcher, "ban");
        super.register(dispatcher, commandRegistry, environment);
    }

    @Override
    public List<String> getNames() {
        return List.of("ban");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(3))
                .then(method_9244("targets", class_2191.method_9329())
                        .executes(context -> execute(context, class_2191.method_9330(context, "targets"), null, null))
                        .then(method_9244("reason", StringArgumentType.greedyString())
                                .executes(context -> execute(context, class_2191.method_9330(context, "targets"), StringArgumentType.getString(context, "reason"), null))));

    }
}
