package me.alexdevs.solstice.modules.customName;

import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.api.text.Format;
import me.alexdevs.solstice.api.text.RawPlaceholder;
import me.alexdevs.solstice.integrations.LuckPermsIntegration;
import me.alexdevs.solstice.modules.customName.commands.NicknameCommand;
import me.alexdevs.solstice.modules.customName.data.CustomNameConfig;
import me.alexdevs.solstice.modules.customName.data.CustomNameLocale;
import me.alexdevs.solstice.modules.customName.data.CustomNamePlayerData;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;

public class CustomNameModule extends ModuleBase.Toggleable {
    public static final Pattern BASIC_NICKNAME_FILTER = Pattern.compile("[^a-zA-Zà-üÀ-Ü_ ]");

    public CustomNameModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        registerConfig(CustomNameConfig.class, CustomNameConfig::new);
        registerLocale(CustomNameLocale.MODULE);
        registerPlayerData(CustomNamePlayerData.class, CustomNamePlayerData::new);

        commands.add(new NicknameCommand(this));
    }

    public String fetchUsernameFormat(class_3222 player) {
        var formats = Solstice.configManager.getData(CustomNameConfig.class).nameFormats;

        String format = null;
        for (var f : formats) {
            if (LuckPermsIntegration.isInGroup(player, f.group())) {
                format = f.format();
                break;
            }
        }

        var isOperator = player.method_5682().method_3760().method_14569(player.method_7334());

        if (format == null) {
            format = "${username}";

            for (var f : formats) {
                if (isOperator && f.group().equals("operator")) {
                    format = f.format();
                    break;
                }
                if (f.group().equals("default")) {
                    format = f.format();
                    break;
                }
            }
        }

        return format;
    }

    public String getResolvedUsername(class_3222 player) {
        var format = fetchUsernameFormat(player);
        var playerData = Solstice.playerData.get(player).getData(CustomNamePlayerData.class);
        var name = playerData.nickname == null ? player.method_7334().getName() : playerData.nickname;

        var prefix = LuckPermsIntegration.getPrefix(player);
        var suffix = LuckPermsIntegration.getSuffix(player);
        if (prefix == null)
            prefix = "";
        if (suffix == null)
            suffix = "";

        Map<String, String> placeholders = Map.of(
                "name", name,
                "prefix", prefix,
                "suffix", suffix
        );

        return RawPlaceholder.parse(format, placeholders);
    }

    public class_5250 getNameForPlayer(class_3222 player) {
        var name = getResolvedUsername(player);
        var playerContext = PlaceholderContext.of(player);
        return Format.parse(name, playerContext).method_27661();
    }

    public @Nullable String getCustomName(class_3222 player) {
        return getCustomName(player.method_5667());
    }

    public @Nullable String getCustomName(UUID uuid) {
        var playerData = Solstice.playerData.get(uuid).getData(CustomNamePlayerData.class);
        return playerData.nickname;
    }

    public void setCustomName(class_3222 player, String name) {
        setCustomName(player, name, true);
    }

    public void setCustomName(class_3222 player, String name, boolean advancedFormatting) {
        setCustomName(player.method_5667(), name, advancedFormatting);
    }

    public void setCustomName(UUID uuid, String name, boolean advancedFormatting) {
        if (!advancedFormatting) {
            name = BASIC_NICKNAME_FILTER.matcher(name).replaceAll("");
        }

        var playerData = Solstice.playerData.get(uuid).getData(CustomNamePlayerData.class);
        playerData.nickname = name;
    }

    public void clearCustomName(class_3222 player) {
        clearCustomName(player.method_5667());
    }

    public void clearCustomName(UUID uuid) {
        var playerData = Solstice.playerData.get(uuid).getData(CustomNamePlayerData.class);
        playerData.nickname = null;
    }
}
