package me.alexdevs.solstice.modules.customName.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.alexdevs.solstice.api.command.LocalGameProfile;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.customName.CustomNameModule;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class NicknameCommand extends ModCommand<CustomNameModule> {

    public NicknameCommand(CustomNameModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("nickname", "nick");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(2))
                .then(method_9244("nickname", StringArgumentType.string())
                        .executes(this::executeSetSelf)
                )
                .then(method_9247("clear")
                        .executes(this::executeClearSelf)
                )
                .then(method_9244("player", StringArgumentType.word())
                        .requires(require("others", 2))
                        .suggests(LocalGameProfile::suggest)
                        .then(method_9244("nickname", StringArgumentType.string())
                                .executes(this::executeSetOthers)
                        )
                        .then(method_9247("clear")
                                .executes(this::executeClearOthers)
                        )
                );
    }

    private boolean hasAdvancedPermission(class_2168 source) {
        return Permissions.check(source, getPermissionNode("advanced.base"), 2);
    }

    private boolean hasAdvancedPermissionOthers(class_2168 source) {
        return Permissions.check(source, getPermissionNode("advanced.others"), 3);
    }

    private int executeSetSelf(CommandContext<class_2168> context) throws CommandSyntaxException {
        var player = context.getSource().method_9207();

        var nickname = StringArgumentType.getString(context, "nickname");

        if(nickname.isEmpty()) {
            context.getSource().method_9213(module.locale().get("errorEmpty"));
            return 0;
        }

        module.setCustomName(
                player,
                nickname,
                hasAdvancedPermission(context.getSource())
        );

        var map = Map.of(
                "player", player.method_5477(),
                "nickname", class_2561.method_30163(module.getCustomName(player))
        );
        context.getSource().method_9226(() -> module.locale().get("setSelf", map), true);

        return 1;
    }

    private int executeClearSelf(CommandContext<class_2168> context) throws CommandSyntaxException {
        var player = context.getSource().method_9207();
        module.clearCustomName(player);

        var map = Map.of(
                "player", player.method_5477(),
                "nickname", class_2561.method_30163(module.getCustomName(player))
        );
        context.getSource().method_9226(() -> module.locale().get("clearedSelf", map), true);

        return 1;
    }

    private int executeSetOthers(CommandContext<class_2168> context) throws CommandSyntaxException {
        var profile = LocalGameProfile.getProfile(context, "player");

        var nickname = StringArgumentType.getString(context, "nickname");

        if(nickname.isEmpty()) {
            context.getSource().method_9213(module.locale().get("errorEmpty"));
            return 0;
        }

        module.setCustomName(
                profile.getId(),
                nickname,
                hasAdvancedPermissionOthers(context.getSource())
        );

        var map = Map.of(
                "player", class_2561.method_30163(profile.getName()),
                "nickname", class_2561.method_30163(module.getCustomName(profile.getId()))
        );
        context.getSource().method_9226(() -> module.locale().get("setOther", map), true);

        return 1;
    }

    private int executeClearOthers(CommandContext<class_2168> context) throws CommandSyntaxException {
        var profile = LocalGameProfile.getProfile(context, "player");

        module.clearCustomName(profile.getId());

        var map = Map.of(
                "player", class_2561.method_30163(profile.getName()),
                "nickname", class_2561.method_30163(module.getCustomName(profile.getId()))
        );
        context.getSource().method_9226(() -> module.locale().get("clearedOther", map), true);

        return 1;
    }
}
