package me.alexdevs.solstice.modules.experiments.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.alexdevs.solstice.api.command.Flags;
import me.alexdevs.solstice.api.command.flags.ArgumentFlag;
import me.alexdevs.solstice.api.command.flags.DoubleFlag;
import me.alexdevs.solstice.api.command.flags.Flag;
import me.alexdevs.solstice.api.command.flags.StringFlag;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.experiments.ExperimentsModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import java.util.List;

public class FlagsCommand extends ModCommand<ExperimentsModule> {
    public FlagsCommand(ExperimentsModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("flags");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return class_2170.method_9247(name)
                .requires(require(true))
                .then(class_2170.method_9244("flags", StringArgumentType.greedyString())
                        .executes(context -> {
                            var source = context.getSource();

                            var testFlag = Flag.of("test");
                            var stringFlag = new StringFlag("string", List.of('s'));
                            var numberFlag = new DoubleFlag("number", List.of('n'));

                            Flags.parse(StringArgumentType.getString(context, "flags"), testFlag, stringFlag, numberFlag);

                            for (var flag : List.of(testFlag, stringFlag, numberFlag)) {
                                if (flag.isUsed()) {
                                    if (flag.acceptsValue() && flag instanceof ArgumentFlag<?> argFlag) {
                                        var value = argFlag.getValue();
                                        source.method_45068(class_2561.method_30163(String.format("Flag %s: %s", flag.getName(), value)));

                                    } else {
                                        source.method_45068(class_2561.method_30163(String.format("Flag %s", flag.getName())));
                                    }
                                }
                            }

                            return 1;
                        })
                );
    }


}
