package me.alexdevs.solstice.modules.experiments.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.alexdevs.solstice.api.command.TimeSpan;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.experiments.ExperimentsModule;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class TimeSpanCommand extends ModCommand<ExperimentsModule> {

    public TimeSpanCommand(ExperimentsModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("timespan");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(true))
                .then(method_9244("timespan", StringArgumentType.string())
                        .suggests(TimeSpan::suggest)
                        .executes(this::execute));
    }

    private int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        var timespan = TimeSpan.getTimeSpan(context, "timespan");
        context.getSource().method_9226(() -> class_2561.method_30163(String.format("Got %s (%d)", TimeSpan.toShortString(timespan), timespan)), false);
        return 1;
    }
}
