package me.alexdevs.solstice.modules.ignore.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.ignore.IgnoreModule;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class IgnoreCommand extends ModCommand<IgnoreModule> {
    public IgnoreCommand(IgnoreModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("ignore");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(true))
                .then(method_9244("target", StringArgumentType.word())
                        .suggests((context, builder) -> {
                            var player = context.getSource().method_9207();
                            var playerManager = context.getSource().method_9211().method_3760();
                            return class_2172.method_9264(Arrays.stream(playerManager.method_14580()).filter(s -> !s.equals(player.method_7334().getName())), builder);
                        })
                        .executes(context -> {
                            var player = context.getSource().method_9207();

                            var targetName = StringArgumentType.getString(context, "target");

                            context.getSource().method_9211().method_3793().method_37156(targetName).thenAcceptAsync(profileOpt -> {
                                var playerContext = PlaceholderContext.of(player);

                                if (profileOpt.isEmpty()) {
                                    context.getSource().method_9226(() -> module.locale().get("playerNotFound", playerContext), false);
                                    return;
                                }

                                var profile = profileOpt.get();

                                if (profile.getId().equals(player.method_7334().getId())) {
                                    context.getSource().method_9226(() -> module.locale().get("targetIsSelf", playerContext), false);
                                    return;
                                }

                                var playerData = module.getPlayerData(player.method_5667());

                                var map = Map.of("targetName", class_2561.method_30163(profile.getName()));

                                if (playerData.ignoredPlayers.contains(profile.getId())) {
                                    playerData.ignoredPlayers.remove(profile.getId());
                                    context.getSource().method_9226(() -> module.locale().get("unblockedPlayer", playerContext, map), false);

                                } else {
                                    playerData.ignoredPlayers.add(profile.getId());
                                    context.getSource().method_9226(() -> module.locale().get("blockedPlayer", playerContext, map), false);
                                }
                            });

                            return 1;
                        }));
    }
}
