package me.alexdevs.solstice.modules.kit.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.gui.SimpleGui;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.kit.KitModule;
import net.minecraft.class_1707;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3917;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class KitsCommand extends ModCommand<KitModule> {
    public KitsCommand(KitModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("kits");
    }

    private static final LinkedHashMap<Integer, class_3917<class_1707>> invSizes = new LinkedHashMap<>();

    static {
        invSizes.put(9, class_3917.field_18664);
        invSizes.put(18, class_3917.field_18665);
        invSizes.put(27, class_3917.field_17326);
        invSizes.put(36, class_3917.field_18666);
        invSizes.put(45, class_3917.field_18667);
        invSizes.put(54, class_3917.field_17327);
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return class_2170.method_9247(name)
                .requires(require(true))
                .executes(context -> {
                    var player = context.getSource().method_9207();

                    var playerAvailableKits = module.getPlayerKitNames(player);
                    var size = playerAvailableKits.size();
                    class_3917<class_1707> handlerType = null;
                    for (var entry : invSizes.entrySet()) {
                        handlerType = entry.getValue();
                        if (size <= entry.getKey()) {
                            break;
                        }
                    }

                    var gui = new SimpleGui(handlerType, player, false);

                    refreshGui(context, gui);

                    gui.setTitle(module.locale().get("kits"));
                    gui.open();

                    return 1;
                });
    }

    private void refreshGui(CommandContext<class_2168> context, SimpleGui gui) throws CommandSyntaxException {
        var player = context.getSource().method_9207();

        var playerAvailableKits = module.getPlayerKitNames(player);
        var kits = module.getKits();

        var size = playerAvailableKits.size();

        for (var i = 0; i < Math.min(size, 54); i++) {
            var kitName = playerAvailableKits.get(i);
            var kit = kits.get(kitName);

            var canClaim = module.couldClaimKit(player, kitName);

            var icon = kit.getIcon();

            var placeholders = Map.of(
                    "kit", class_2561.method_30163(kitName)
            );
            class_2561 kitNameComponent;
            class_2561 kitLoreComponent;
            if (canClaim) {
                kitNameComponent = class_2561.method_30163(kitName);
                kitLoreComponent = module.locale().get("claimKit", placeholders);
                icon.method_57379(class_9334.field_49641, true);
            } else {

                kitNameComponent = module.locale().get("kitsUnavailableName", placeholders);
                kitLoreComponent = module.locale().get("kitsUnavailableLore", placeholders);
            }

            icon.method_57379(class_9334.field_49631, kitNameComponent);
            icon.method_57379(class_9334.field_49632, new class_9290(List.of(kitLoreComponent)));

            gui.setSlot(i, new GuiElement(icon, (syncId, clickType, slotActionType) -> {
                try {
                    dispatcher.execute("kit claim " + kitName, context.getSource());
                    refreshGui(context, gui);
                } catch (CommandSyntaxException e) {
                    context.getSource().method_9213(class_2561.method_30163(e.getLocalizedMessage()));
                }
            }));
        }
    }
}
