package me.alexdevs.solstice.modules.miscellaneous.commands;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.miscellaneous.MiscellaneousModule;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import java.util.List;

public class NudgeCommand extends ModCommand<MiscellaneousModule> {
    public NudgeCommand(MiscellaneousModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("nudge");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return class_2170.method_9247(name)
                .requires(require("nudge.base", 2))
                .then(class_2170.method_9244("entities", class_2186.method_9306())
                        .executes(context -> this.execute(context, 1, false))
                        .then(class_2170.method_9244("power", FloatArgumentType.floatArg(0, 32))
                                .executes(context -> this.execute(context, FloatArgumentType.getFloat(context, "power"), false))
                                .then(class_2170.method_9244("quiet", BoolArgumentType.bool())
                                        .executes(context -> this.execute(context, FloatArgumentType.getFloat(context, "power"), BoolArgumentType.getBool(context, "quiet")))
                                )
                        ));
    }

    private int execute(CommandContext<class_2168> context, float power, boolean quiet) throws CommandSyntaxException {
        var entities = class_2186.method_9317(context, "entities");

        var random = context.getSource().method_9211().method_30002().method_8409();

        for (var entity : entities) {
            if (entity instanceof class_1309 living) {
                var angle = random.method_43058() * Math.PI * 2;
                var x = Math.sin(angle);
                var z = Math.cos(angle);
                var vec = new class_243(x, 0, z).method_1029().method_1021(power);

                living.method_18799(vec);
                living.field_6037 = true;
                if (!quiet) {
                    if (entity instanceof class_3222 player) {
                        var pitch = (float) (Math.sin(random.method_43058() * Math.PI * 2) / 10 + 1);
                        player.method_17356(class_3417.field_14914, class_3419.field_15250, 1f, pitch);
                    }
                }
            }
        }

        return 1;
    }
}
