package me.alexdevs.solstice.modules.mute.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.mute.MuteModule;
import net.minecraft.class_2168;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class UnmuteCommand extends ModCommand<MuteModule> {
    public UnmuteCommand(MuteModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("unmute");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(2))
                .then(method_9244("targets", class_2191.method_9329())
                        .executes(context -> {
                            var targets = class_2191.method_9330(context, "targets");

                            targets.forEach(profile -> {
                                var playerData = module.getPlayerData(profile.getId());
                                playerData.muted = false;
                                playerData.mutedUntil = null;
                            });

                            Solstice.playerData.saveAll();

                            String localeKey;
                            if (targets.size() == 1) {
                                localeKey = "unmuted";
                            } else {
                                localeKey = "unmutedMultiple";
                            }

                            var placeholders = Map.of(
                                    "count", class_2561.method_30163(String.valueOf(targets.size())),
                                    "player", class_2561.method_30163(targets.stream().findFirst().get().getName())
                            );

                            context.getSource().method_9226(() -> module.locale().get(localeKey, placeholders), true);

                            return 1;
                        }));
    }
}
