package me.alexdevs.solstice.modules.teleportPosition.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import me.alexdevs.solstice.api.ServerLocation;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.teleportPosition.TeleportPositionModule;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import java.util.List;
import java.util.Locale;

public class TeleportPositionCommand extends ModCommand<TeleportPositionModule> {
    public static final SimpleCommandExceptionType INVALID_POSITION_EXCEPTION = new SimpleCommandExceptionType(class_2561.method_43471("commands.teleport.invalidPosition"));

    public TeleportPositionCommand(TeleportPositionModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("tppos");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return class_2170.method_9247(name)
                .requires(require(2))
                .then(class_2170.method_9244("coordinates", class_2277.method_9737())
                        .executes(context -> execute(context, context.getSource().method_9225()))
                        .then(class_2170.method_9244("dimension", class_2181.method_9288())
                                .executes(context -> execute(context, class_2181.method_9289(context, "dimension")))
                        )
                );
    }

    private static String formatFloat(double d) {
        return String.format(Locale.ROOT, "%f", d);
    }

    private int execute(CommandContext<class_2168> context, class_3218 world) throws CommandSyntaxException {
        var player = context.getSource().method_9207();
        var coords = class_2277.method_9736(context, "coordinates");

        var blockPos = class_2338.method_49637(coords.method_10216(), coords.method_10214(), coords.method_10215());
        if (!class_1937.method_25953(blockPos)) {
            throw INVALID_POSITION_EXCEPTION.create();
        }

        var location = new ServerLocation(
                coords.method_10216(), coords.method_10214(), coords.method_10215(),
                player.method_36454(), player.method_36455(),
                world
        );

        context.getSource().method_9226(() ->
                        class_2561.method_43469("commands.teleport.success.location.single",
                                player.method_5476(),
                                formatFloat(coords.field_1352), formatFloat(coords.field_1351), formatFloat(coords.field_1350)),
                true);

        location.teleport(player);

        return 1;
    }
}
