package me.alexdevs.solstice.modules.teleportRequest.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.teleportRequest.TeleportRequestModule;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_3222;
import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class TeleportDenyCommand extends ModCommand<TeleportRequestModule> {
    public TeleportDenyCommand(TeleportRequestModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("tpdeny", "tpno", "tprefuse");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(true))
                .executes(this::execute)
                .then(method_9244("player", class_2186.method_9305())
                        .executes(context -> this.execute(context, class_2186.method_9315(context, "player")))
                );
    }

    private int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        var player = context.getSource().method_9207();

        var request = module.getLatestRequest(player);
        if (request == null) {
            context.getSource().method_9226(() -> module.locale().get("noPending"), false);
            return 0;
        }
        module.refuseRequest(player, request);

        return 1;
    }

    private int execute(CommandContext<class_2168> context, class_3222 source) throws CommandSyntaxException {
        var player = context.getSource().method_9207();

        var request = module.getRequestFromSource(player, source);
        if (request == null) {
            context.getSource().method_9226(() -> module.locale().get("unavailable"), false);
            return 0;
        }
        module.refuseRequest(player, request);

        return 1;
    }
}
