/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.api;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import me.alexdevs.solstice.modules.ModuleProvider;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5275;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class ServerLocation {
    protected final double x;
    protected final double y;
    protected final double z;
    protected final float yaw;
    protected final float pitch;
    protected final String world;
    private static final ImmutableList<class_2248> unsafeBlocks = ImmutableList.of((Object)class_2246.field_10164, (Object)class_2246.field_10092, (Object)class_2246.field_10029, (Object)class_2246.field_10036, (Object)class_2246.field_17350, (Object)class_2246.field_27098, (Object)class_2246.field_16999, (Object)class_2246.field_27879);
    public static final int SAFE_RANGE = 5;

    public ServerLocation(double x, double y, double z, float yaw, float pitch, class_3218 world) {
        this(x, y, z, yaw, pitch, world.method_27983().method_29177().toString());
    }

    public ServerLocation(class_3222 player) {
        this(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455(), player.method_51469().method_27983().method_29177().toString());
    }

    public ServerLocation(double x, double y, double z, float yaw, float pitch, String worldKey) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.world = worldKey;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerLocation that = (ServerLocation)o;
        return Double.compare(this.getX(), that.getX()) == 0 && Double.compare(this.getY(), that.getY()) == 0 && Double.compare(this.getZ(), that.getZ()) == 0 && Float.compare(this.getYaw(), that.getYaw()) == 0 && Float.compare(this.getPitch(), that.getPitch()) == 0 && Objects.equals(this.getWorld(), that.getWorld());
    }

    public int hashCode() {
        return Objects.hash(this.getX(), this.getY(), this.getZ(), Float.valueOf(this.getYaw()), Float.valueOf(this.getPitch()), this.getWorld());
    }

    public void teleport(class_3222 player, boolean setBackPosition) {
        if (setBackPosition) {
            ServerLocation currentPosition = new ServerLocation(player);
            ModuleProvider.BACK.setPlayerLastLocation(player.method_5667(), currentPosition);
        }
        class_3218 serverWorld = this.getWorld(player.method_5682());
        player.method_18799(player.method_18798().method_18805(1.0, 0.0, 1.0));
        player.method_24830(true);
        player.method_14251(serverWorld, this.getX(), this.getY(), this.getZ(), this.getYaw(), this.getPitch());
        player.method_7255(0);
    }

    public void teleport(class_3222 player) {
        this.teleport(player, true);
    }

    public class_5321<class_1937> getWorldKey() {
        return class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)this.getWorld()));
    }

    public class_3218 getWorld(MinecraftServer server) {
        return server.method_3847(this.getWorldKey());
    }

    public class_2338 getBlockPos() {
        return class_2338.method_49637((double)this.getX(), (double)this.getY(), (double)this.getZ());
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public String getWorld() {
        return this.world;
    }

    public double getDistance(ServerLocation other) {
        if (!other.getWorld().equals(this.getWorld())) {
            return Double.POSITIVE_INFINITY;
        }
        class_243 thisVec = new class_243(this.getX(), this.getY(), this.getZ());
        class_243 otherVec = new class_243(other.getX(), other.getY(), other.getZ());
        return thisVec.method_1022(otherVec);
    }

    public class_243 getDelta(ServerLocation other) {
        return new class_243(this.getX() - other.getX(), this.getY() - other.getY(), this.getZ() - other.getZ());
    }

    public boolean safeTeleport(class_3222 player, boolean setBackPosition, int range) {
        class_3218 world = this.getWorld(player.method_5682());
        int horRange = (int)Math.pow(range, 2.0);
        for (int i = 1; i <= horRange; ++i) {
            class_2382 rel = ServerLocation.spiral(i);
            class_2338 attemptPos = this.getBlockPos().method_10081(rel);
            for (int j = 0; j < range * 2; ++j) {
                int y = j % 2 == 0 ? -j / 2 : j / 2 + 1;
                class_243 safePos = class_5275.method_30769((class_1299)class_1299.field_6097, (class_1941)world, (class_2338)attemptPos.method_10069(0, y, 0), (boolean)true);
                if (safePos == null) continue;
                ServerLocation safeLocation = new ServerLocation(safePos.field_1352, safePos.field_1351, safePos.field_1350, this.getYaw(), this.getPitch(), this.getWorld());
                safeLocation.teleport(player, setBackPosition);
                return true;
            }
        }
        return false;
    }

    public boolean safeTeleport(class_3222 player) {
        return this.safeTeleport(player, true, 5);
    }

    public static class_2382 spiral(int n) {
        if (n == 0) {
            return class_2382.field_11176;
        }
        int k = (int)Math.ceil((Math.sqrt(n) - 1.0) / 2.0);
        int t = 2 * k + 1;
        int m = (int)Math.pow(t, 2.0);
        if (n >= m - --t) {
            int x = k - (m - n);
            int z = -k;
            return new class_2382(x, 0, z);
        }
        if (n >= (m -= t) - t) {
            int x = -k;
            int z = -k + (m - n);
            return new class_2382(x, 0, z);
        }
        if (n >= (m -= t) - t) {
            int x = -k + (m - n);
            int z = k;
            return new class_2382(x, 0, z);
        }
        int x = k;
        int z = k - (m - n - t);
        return new class_2382(x, 0, z);
    }
}

