/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.api.command;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import me.alexdevs.solstice.api.command.flags.Flag;

public class Flags {
    public static void parse(String input, Flag ... flags) throws CommandSyntaxException {
        List<String> args = Flags.parseArgs(input);
        Flags.parseFlags(args, Arrays.stream(flags).toList());
    }

    private static List<String> parseArgs(String input) {
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder arg = new StringBuilder();
        boolean inQuotes = false;
        boolean escape = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (escape) {
                arg.append(c);
                escape = false;
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            if (c == ' ' && !inQuotes) {
                if (arg.isEmpty()) continue;
                args.add(arg.toString());
                arg.setLength(0);
                continue;
            }
            arg.append(c);
        }
        if (!arg.isEmpty()) {
            args.add(arg.toString());
        }
        return args;
    }

    private static void parseFlags(List<String> args, List<Flag> flags) throws CommandSyntaxException {
        Iterator<String> iter = args.iterator();
        while (iter.hasNext()) {
            String arg = iter.next();
            if (!arg.startsWith("-")) continue;
            if (arg.startsWith("--")) {
                String argName = arg.substring(2);
                for (Flag flag : flags) {
                    if (!argName.equals(flag.getName())) continue;
                    if (flag.acceptsValue()) {
                        flag.accept(iter.next());
                        continue;
                    }
                    flag.accept();
                }
                continue;
            }
            String f = arg.substring(1);
            for (Object c : (Object)f.toCharArray()) {
                for (Flag flag : flags) {
                    if (!flag.getShortFlags().contains(Character.valueOf((char)c))) continue;
                    if (flag.acceptsValue()) {
                        flag.accept(iter.next());
                        continue;
                    }
                    flag.accept();
                }
            }
        }
    }
}

