/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.api.command.flags;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Flag
implements Comparable<Flag> {
    public static final SimpleCommandExceptionType UNEXPECTED_VALUE = new SimpleCommandExceptionType((Message)new LiteralMessage("Unexpected value"));
    protected final String name;
    protected final List<Character> shortFlags = new ArrayList<Character>();
    protected boolean isUsed = false;

    public Flag(String name, List<Character> shortNames) {
        this.name = name;
        this.shortFlags.addAll(shortNames);
    }

    public String getName() {
        return this.name;
    }

    public List<Character> getShortFlags() {
        return Collections.unmodifiableList(this.shortFlags);
    }

    public boolean acceptsValue() {
        return false;
    }

    public boolean isUsed() {
        return this.isUsed;
    }

    public Flag clone() {
        return new Flag(this.name, this.shortFlags);
    }

    public void accept(String value) throws CommandSyntaxException {
        throw UNEXPECTED_VALUE.create();
    }

    public void accept() {
        this.isUsed = true;
    }

    public static Flag of(String name) {
        return new Flag(name, Collections.emptyList());
    }

    @Override
    public int compareTo(@NotNull Flag o) {
        return this.name.compareTo(o.name);
    }
}

