/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.api.command.flags;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import me.alexdevs.solstice.api.command.flags.ArgumentFlag;
import me.alexdevs.solstice.api.command.flags.Flag;

public class StringFlag
extends ArgumentFlag<String> {
    protected String value;
    protected final StringArgumentType type = StringArgumentType.string();

    public StringFlag(String name, List<Character> shortFlags) {
        super(name, shortFlags);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void accept(String input) throws CommandSyntaxException {
        this.isUsed = true;
        this.value = this.type.parse(new StringReader(input));
    }

    public static String get(String name, List<Flag> flags) {
        for (Flag flag : flags) {
            if (!flag.getName().equals(name) || !(flag instanceof StringFlag)) continue;
            StringFlag stringFlag = (StringFlag)flag;
            return stringFlag.getValue();
        }
        return null;
    }

    @Override
    public StringFlag clone() {
        return new StringFlag(this.name, this.shortFlags);
    }
}

