/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.api.module;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.events.ModuleCommandEvents;
import me.alexdevs.solstice.api.module.Debug;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.mixin.CommandNodeAccessor;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_7157;

public abstract class ModCommand<T extends ModuleBase> {
    protected final T module;
    protected CommandDispatcher<class_2168> dispatcher = null;
    protected class_7157 commandRegistry = null;
    protected class_2170.class_5364 environment = null;

    public ModCommand(T module) {
        this.module = module;
    }

    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistry, class_2170.class_5364 environment) {
        this.dispatcher = dispatcher;
        this.commandRegistry = commandRegistry;
        this.environment = environment;
        ArrayList<String> aliases = new ArrayList<String>(this.getNames());
        String name = aliases.remove(0);
        LiteralCommandNode<class_2168> node = this.registerCommand(this.command(name));
        for (String alias : aliases) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)alias).requires(node.getRequirement())).executes(node.getCommand())).redirect(node));
        }
    }

    protected void setCommand(CommandNode<class_2168> node, Command<class_2168> command) {
        ((CommandNodeAccessor)node).setCommand(command);
    }

    protected void injectPreCommandEvents(CommandNode<class_2168> command, String node) {
        Command commandExecutor = command.getCommand();
        if (commandExecutor != null) {
            Solstice.LOGGER.debug("Registering pre-command event for command {}#{}", (Object)((ModuleBase)this.module).getId(), (Object)node);
            this.setCommand(command, (Command<class_2168>)((Command)context -> {
                boolean isAllowed = ((ModuleCommandEvents.AllowCommand)ModuleCommandEvents.ALLOW_COMMAND.invoker()).allowCommand(node, (CommandContext<class_2168>)context, this);
                if (isAllowed) {
                    ((ModuleCommandEvents.Command)ModuleCommandEvents.COMMAND.invoker()).onCommand(node, (CommandContext<class_2168>)context, this);
                    return commandExecutor.run(context);
                }
                return 0;
            }));
        }
        for (CommandNode child : command.getChildren()) {
            this.injectPreCommandEvents((CommandNode<class_2168>)child, node + "." + child.getName());
        }
    }

    public LiteralCommandNode<class_2168> registerCommand(LiteralArgumentBuilder<class_2168> command) {
        LiteralCommandNode node = this.dispatcher.register(command);
        this.injectPreCommandEvents((CommandNode<class_2168>)node, node.getName());
        return node;
    }

    public String getName() {
        return this.getNames().stream().findFirst().orElseGet(() -> this.getClass().getSimpleName().toLowerCase());
    }

    public String getPermissionNode() {
        String node = ((ModuleBase)this.module).getPermissionNode("base");
        Debug.commandDebugList.add(new Debug.CommandDebug(((ModuleBase)this.module).id, this.getName(), this.getNames(), node));
        return node;
    }

    public String getPermissionNode(String subNode) {
        String node = ((ModuleBase)this.module).getPermissionNode(subNode);
        Debug.commandDebugList.add(new Debug.CommandDebug(((ModuleBase)this.module).id, this.getName(), this.getNames(), node));
        return node;
    }

    public Predicate<class_2168> require() {
        return Permissions.require((String)this.getPermissionNode());
    }

    public Predicate<class_2168> require(int defaultRequiredLevel) {
        return Permissions.require((String)this.getPermissionNode(), (int)defaultRequiredLevel);
    }

    public Predicate<class_2168> require(boolean defaultValue) {
        return Permissions.require((String)this.getPermissionNode(), (boolean)defaultValue);
    }

    public Predicate<class_2168> require(String subNode) {
        return Permissions.require((String)this.getPermissionNode(subNode));
    }

    public Predicate<class_2168> require(String subNode, int defaultRequiredLevel) {
        return Permissions.require((String)this.getPermissionNode(subNode), (int)defaultRequiredLevel);
    }

    public Predicate<class_2168> require(String subNode, boolean defaultValue) {
        return Permissions.require((String)this.getPermissionNode(subNode), (boolean)defaultValue);
    }

    public abstract List<String> getNames();

    public abstract LiteralArgumentBuilder<class_2168> command(String var1);
}

