/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.api.module;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.core.ToggleableConfig;
import me.alexdevs.solstice.locale.Locale;
import net.minecraft.class_2960;

public abstract class ModuleBase
implements Comparable<ModuleBase> {
    protected final class_2960 id;
    protected final List<ModCommand<?>> commands = new ArrayList();
    protected Class<?> configClass = null;
    protected Class<?> playerDataClass = null;
    protected Class<?> serverDataClass = null;

    public ModuleBase(class_2960 id) {
        this.id = id;
    }

    public abstract void init();

    public Collection<? extends ModCommand<?>> getCommands() {
        return this.commands;
    }

    public class_2960 getId() {
        return this.id;
    }

    public String getPermissionNode() {
        return this.id.method_12836() + "." + this.id.method_12832();
    }

    public String getPermissionNode(String sub) {
        return this.getPermissionNode() + "." + sub;
    }

    public Locale locale() {
        return Solstice.localeManager.getLocale(this.id);
    }

    public <T> void registerConfig(Class<T> clazz, Supplier<T> creator) {
        Solstice.configManager.registerData(this.id, clazz, creator);
    }

    public <T> void registerPlayerData(Class<T> clazz, Supplier<T> creator) {
        Solstice.playerData.registerData(this.id, clazz, creator);
    }

    public <T> void registerServerData(Class<T> clazz, Supplier<T> creator) {
        Solstice.serverData.registerData(this.id, clazz, creator);
    }

    public void registerLocale(Map<String, String> map) {
        Solstice.localeManager.registerModule(this.id, map);
    }

    public void registerSharedLocale(Map<String, String> map) {
        Solstice.localeManager.registerShared(map);
    }

    public String toString() {
        return "Module [" + String.valueOf(this.id) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleBase)) {
            return false;
        }
        ModuleBase that = (ModuleBase)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    @Override
    public int compareTo(ModuleBase o) {
        return this.id.method_12833(o.id);
    }

    public static abstract class Toggleable
    extends ModuleBase {
        public Toggleable(class_2960 id) {
            super(id);
        }

        public boolean isEnabled() {
            return ToggleableConfig.get().isEnabled(this.id.toString());
        }
    }
}

