/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.api.text;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.text.Format;
import me.alexdevs.solstice.api.text.TextCapabilities;
import me.alexdevs.solstice.api.text.parser.MarkdownParser;
import me.alexdevs.solstice.locale.Locale;
import me.alexdevs.solstice.modules.ModuleProvider;
import me.alexdevs.solstice.modules.styling.data.StylingConfig;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7471;

public class Components {
    private static final Random random = new Random();

    public static class_2561 button(class_2561 label, class_2561 hoverText, String command, boolean suggest) {
        Locale locale = Solstice.localeManager.getShared();
        String format = suggest ? locale.raw("~buttonSuggest") : locale.raw("~button");
        Map<String, class_2561> placeholders = Map.of("label", label, "hoverText", hoverText, "command", class_2561.method_30163((String)command));
        class_2561 text = Format.parse(format);
        return Format.parse(text, placeholders);
    }

    public static class_2561 button(String label, String hoverText, String command) {
        return Components.button(Format.parse(label), Format.parse(hoverText), command, false);
    }

    public static class_2561 buttonSuggest(String label, String hoverText, String command) {
        return Components.button(Format.parse(label), Format.parse(hoverText), command, true);
    }

    public static class_2561 chat(class_7471 message, class_3222 player) {
        boolean allowAdvancedChatFormat = Permissions.check((class_1297)player, (String)"solstice.chat.advanced");
        boolean allowLegacyChatFormat = Permissions.check((class_1297)player, (String)"solstice.chat.legacy");
        EnumSet<TextCapabilities> set = EnumSet.noneOf(TextCapabilities.class);
        if (allowAdvancedChatFormat) {
            set.add(TextCapabilities.ADVANCED);
        }
        if (allowLegacyChatFormat) {
            set.add(TextCapabilities.LEGACY);
        }
        if (ModuleProvider.STYLING.isEnabled()) {
            StylingConfig config = Solstice.configManager.getData(StylingConfig.class);
            if (config.enableMarkdown) {
                set.add(TextCapabilities.MARKDOWN);
            }
        }
        return Components.chat(message.method_44862(), set, player.method_5671());
    }

    public static class_2561 chat(String message, class_3222 player) {
        boolean allowAdvancedChatFormat = Permissions.check((class_1297)player, (String)"solstice.chat.advanced");
        boolean allowLegacyChatFormat = Permissions.check((class_1297)player, (String)"solstice.chat.legacy");
        EnumSet<TextCapabilities> set = EnumSet.noneOf(TextCapabilities.class);
        if (allowAdvancedChatFormat) {
            set.add(TextCapabilities.ADVANCED);
        }
        if (allowLegacyChatFormat) {
            set.add(TextCapabilities.LEGACY);
        }
        if (ModuleProvider.STYLING.isEnabled()) {
            StylingConfig config = Solstice.configManager.getData(StylingConfig.class);
            if (config.enableMarkdown) {
                set.add(TextCapabilities.MARKDOWN);
            }
        }
        return Components.chat(message, set, player.method_5671());
    }

    public static class_2561 chat(String message, EnumSet<TextCapabilities> capabilities, class_2168 source) {
        boolean enableMarkdown = capabilities.contains((Object)TextCapabilities.MARKDOWN);
        boolean enableAdvanced = capabilities.contains((Object)TextCapabilities.ADVANCED);
        boolean enableLegacy = capabilities.contains((Object)TextCapabilities.LEGACY);
        HashMap<String, class_2561> placeholders = new HashMap<String, class_2561>();
        PlaceholderContext context = PlaceholderContext.of((class_2168)source);
        if (ModuleProvider.STYLING.isEnabled()) {
            StylingConfig config = Solstice.configManager.getData(StylingConfig.class);
            for (Map.Entry<String, String> repl : config.replacements.entrySet()) {
                if (!message.contains(repl.getKey())) continue;
                String key = Integer.toHexString(random.nextInt(24));
                message = message.replace(repl.getKey(), String.format("${%s}", key));
                String value = repl.getValue().replace("\\", "\\\\");
                placeholders.put(key, Format.parse(value, context));
            }
        }
        if (capabilities.isEmpty()) {
            return Placeholders.parseText((TextNode)TextNode.of((String)message), (Pattern)Format.PLACEHOLDER_PATTERN, placeholders);
        }
        ArrayList<NodeParser> parsers = new ArrayList<NodeParser>();
        if (enableAdvanced) {
            parsers.add(Format.PARSER);
        }
        if (enableLegacy) {
            parsers.add(Format.LEGACY_PARSER);
        }
        if (enableMarkdown) {
            parsers.add(MarkdownParser.defaultParser);
        }
        NodeParser parser = NodeParser.merge((NodeParser[])((NodeParser[])parsers.toArray(NodeParser[]::new)));
        TextNode node = parser.parseNode(message);
        return Placeholders.parseText((TextNode)node, (Pattern)Format.PLACEHOLDER_PATTERN, placeholders);
    }

    public static class_2561 chat(String message, class_2168 source) {
        if (source.method_43737()) {
            return Components.chat(message, source.method_44023());
        }
        return Components.chat(message, EnumSet.allOf(TextCapabilities.class), source);
    }
}

