/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.api.text.parser;

import eu.pb4.placeholders.api.node.DirectTextNode;
import eu.pb4.placeholders.api.node.LiteralNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.parent.ParentNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.alexdevs.solstice.api.text.Format;
import me.alexdevs.solstice.core.coreModule.CoreModule;
import me.alexdevs.solstice.core.coreModule.data.CoreConfig;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class LinkParser
implements NodeParser {
    public static final Pattern URL_REGEX = Pattern.compile("https?:\\/\\/(www\\.)?[-a-zA-Z0-9@:%._\\+~#=]{1,256}\\.[a-zA-Z0-9()]{1,6}\\b([-a-zA-Z0-9()@:%_\\+.~#?&//=]*)");

    public TextNode[] parseNodes(TextNode node) {
        if (node instanceof LiteralNode) {
            String text;
            LiteralNode literalNode = (LiteralNode)node;
            String input = literalNode.value();
            ArrayList<Object> list = new ArrayList<Object>();
            int inputLength = input.length();
            Matcher matcher = URL_REGEX.matcher(input);
            int pos = 0;
            CoreConfig config = CoreModule.getConfig();
            while (matcher.find() && inputLength > matcher.start()) {
                String betweenText = input.substring(pos, matcher.start());
                if (!betweenText.isEmpty()) {
                    list.add(new LiteralNode(betweenText));
                }
                String link = matcher.group();
                class_2561 url = class_2561.method_30163((String)link);
                Map<String, class_2561> placeholders = Map.of("url", url, "label", url);
                class_2561 display = Format.parse(config.link, placeholders);
                class_2561 hover = Format.parse(config.linkHover, placeholders);
                class_5250 text2 = class_2561.method_43473().method_10852(display).method_10862(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)hover)).method_10958(new class_2558(class_2558.class_2559.field_11749, link)));
                list.add(new DirectTextNode((class_2561)text2));
                pos = matcher.end();
            }
            if (pos < inputLength && !(text = input.substring(pos, inputLength)).isEmpty()) {
                list.add(new LiteralNode(text));
            }
            return (TextNode[])list.toArray(TextNode[]::new);
        }
        if (node instanceof ParentNode) {
            ParentNode parentNode = (ParentNode)node;
            ArrayList<TextNode> list = new ArrayList<TextNode>();
            for (TextNode child : parentNode.getChildren()) {
                list.addAll(List.of(this.parseNodes(child)));
            }
            return new TextNode[]{parentNode.copyWith((TextNode[])list.toArray(TextNode[]::new))};
        }
        return TextNode.array((TextNode[])new TextNode[]{node});
    }
}

