/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.api.text.tag;

import com.mojang.serialization.DataResult;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.parent.GradientNode;
import eu.pb4.placeholders.api.parsers.TextParserV1;
import eu.pb4.placeholders.impl.textparser.TextParserImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import me.alexdevs.solstice.api.color.Gradient;
import me.alexdevs.solstice.api.color.RGBColor;
import me.alexdevs.solstice.api.utils.MathUtils;
import net.minecraft.class_5251;

public class PhaseGradientTag {
    public static TextParserV1.TextTag createTag() {
        return TextParserV1.TextTag.of((String)"phase_gradient", List.of("pgr", "sgr"), (String)"gradient", (boolean)true, (tag, data, input, handlers, endAt) -> {
            List<class_5251> textColors;
            String[] rawArgs = data.split(":");
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing((String)input, (TextParserV1.TagParserGetter)handlers, (String)endAt);
            double phase = 0.0;
            Iterator args = Arrays.stream(rawArgs).iterator();
            if (args.hasNext()) {
                textColors = new ArrayList();
                while (args.hasNext()) {
                    Optional<Double> possiblePhase;
                    String arg = (String)args.next();
                    if (!args.hasNext() && (possiblePhase = MathUtils.parseDouble(arg)).isPresent()) {
                        phase = MathUtils.clamp(possiblePhase.get(), -1.0, 1.0);
                        break;
                    }
                    DataResult parsedColor = class_5251.method_27719((String)arg);
                    if (parsedColor.isError()) {
                        textColors.add(class_5251.method_27717((int)0));
                        continue;
                    }
                    textColors.add((class_5251)parsedColor.getOrThrow());
                }
                if (textColors.size() == 1) {
                    return out.value((TextNode)GradientNode.colors(textColors, (TextNode[])out.nodes()));
                }
            } else {
                textColors = List.of();
            }
            return out.value((TextNode)PhaseGradientTag.smoother(textColors, phase, out.nodes()));
        });
    }

    public static GradientNode smoother(List<class_5251> colors, double phase, TextNode ... nodes) {
        if (colors.isEmpty()) {
            colors.add(class_5251.method_27717((int)0xFFFFFF));
            colors.add(class_5251.method_27717((int)0));
        }
        if (phase < 0.0) {
            phase += 1.0;
            Collections.reverse(colors);
        }
        return new GradientNode(nodes, PhaseGradientTag.smoothGradient(colors, phase));
    }

    static GradientNode.GradientProvider smoothGradient(List<class_5251> colors, double phase) {
        double ph = phase * (double)colors.size();
        return (index, length) -> {
            double multiplier = length == 1 ? 0.0 : (double)(colors.size() - 1) / (double)(length - 1);
            double pos = (double)index * multiplier + ph;
            int lowUnclamped = (int)Math.floor(pos);
            int high = (int)Math.ceil(pos) % colors.size();
            int low = lowUnclamped % colors.size();
            return Gradient.lerp((float)pos - (float)lowUnclamped, new RGBColor((class_5251)colors.get(low)), new RGBColor((class_5251)colors.get(high)));
        };
    }
}

