/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.core.coreModule;

import com.mojang.authlib.GameProfile;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.ServerLocation;
import me.alexdevs.solstice.api.events.SolsticeEvents;
import me.alexdevs.solstice.api.events.WorldSaveCallback;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.core.coreModule.commands.PingCommand;
import me.alexdevs.solstice.core.coreModule.commands.ServerStatCommand;
import me.alexdevs.solstice.core.coreModule.commands.SolsticeCommand;
import me.alexdevs.solstice.core.coreModule.data.CoreConfig;
import me.alexdevs.solstice.core.coreModule.data.CoreLocale;
import me.alexdevs.solstice.core.coreModule.data.CorePlayerData;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class CoreModule
extends ModuleBase {
    public CoreModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        this.registerConfig(CoreConfig.class, CoreConfig::new);
        this.registerSharedLocale(CoreLocale.SHARED);
        this.registerLocale(CoreLocale.MODULE);
        this.registerPlayerData(CorePlayerData.class, CorePlayerData::new);
        this.commands.add(new SolsticeCommand(this));
        this.commands.add(new ServerStatCommand(this));
        this.commands.add(new PingCommand(this));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            Solstice.getUserCache().add(handler.method_32311().method_7334());
            class_3222 player = handler.method_32311();
            CorePlayerData playerData = Solstice.playerData.get(player).getData(CorePlayerData.class);
            playerData.username = player.method_7334().getName();
            playerData.lastSeenDate = new Date();
            playerData.ipAddress = handler.method_32311().method_14209();
            if (playerData.firstJoinedDate == null) {
                Solstice.LOGGER.info("Player {} joined for the first time!", (Object)player.method_7334().getName());
                playerData.firstJoinedDate = new Date();
                ((SolsticeEvents.Welcome)SolsticeEvents.WELCOME.invoker()).onWelcome(player, server);
            }
            if (playerData.username != null && !playerData.username.equals(player.method_7334().getName())) {
                Solstice.LOGGER.info("Player {} has changed their username from {}", (Object)player.method_7334().getName(), (Object)playerData.username);
                ((SolsticeEvents.UsernameChange)SolsticeEvents.USERNAME_CHANGE.invoker()).onUsernameChange(player, playerData.username);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            CorePlayerData playerData = Solstice.playerData.get(handler.method_32311()).getData(CorePlayerData.class);
            playerData.lastSeenDate = new Date();
            playerData.logoffPosition = new ServerLocation(handler.method_32311());
            Solstice.scheduler.schedule(() -> Solstice.playerData.dispose(handler.method_32311().method_5667()), 1L, TimeUnit.SECONDS);
        });
        WorldSaveCallback.EVENT.register((server, suppressLogs, flush, force) -> {
            List<UUID> uuids = server.method_3760().method_14571().stream().map(class_1297::method_5667).toList();
            Solstice.playerData.disposeMissing(uuids);
        });
    }

    public static CoreConfig getConfig() {
        return Solstice.configManager.getData(CoreConfig.class);
    }

    public static CorePlayerData getPlayerData(UUID uuid) {
        return Solstice.playerData.get(uuid).getData(CorePlayerData.class);
    }

    public static String getUsername(UUID uuid) {
        Optional profile = Solstice.server.method_3793().method_14512(uuid);
        if (profile.isPresent()) {
            return ((GameProfile)profile.get()).getName();
        }
        return uuid.toString();
    }
}

