/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.core.coreModule.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.alexdevs.solstice.api.command.TimeSpan;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.core.coreModule.CoreModule;
import me.alexdevs.solstice.locale.Locale;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class ServerStatCommand
extends ModCommand<CoreModule> {
    public ServerStatCommand(CoreModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("serverstat", "tps");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require("serverstat", 3))).executes(context -> {
            Locale locale = ((CoreModule)this.module).locale();
            PlaceholderContext placeholderContext = PlaceholderContext.of((class_2168)((class_2168)context.getSource()));
            ArrayList<class_2561> messages = new ArrayList<class_2561>();
            messages.add(locale.get("stat.tps", placeholderContext));
            Duration uptime = Duration.ofMillis(ManagementFactory.getRuntimeMXBean().getUptime());
            String uptimeFormatted = TimeSpan.toShortString((int)uptime.getSeconds());
            messages.add(locale.get("stat.uptime", placeholderContext, Map.of("uptime", class_2561.method_30163((String)uptimeFormatted))));
            long maxMemory = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
            long allocatedMemory = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
            long freeMemory = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
            messages.add(locale.get("stat.maxMemory", placeholderContext, Map.of("memory", class_2561.method_30163((String)String.valueOf(maxMemory)), "hover", locale.get("stat.maxMemory.hover"))));
            messages.add(locale.get("stat.dedicatedMemory", placeholderContext, Map.of("memory", class_2561.method_30163((String)String.valueOf(allocatedMemory)), "hover", locale.get("stat.dedicatedMemory.hover"))));
            messages.add(locale.get("stat.freeMemory", placeholderContext, Map.of("memory", class_2561.method_30163((String)String.valueOf(freeMemory)), "hover", locale.get("stat.freeMemory.hover"))));
            class_5250 text = class_2561.method_43473();
            text.method_10852(locale.get("stat.title"));
            for (class_2561 message : messages) {
                text.method_10852(class_2561.method_30163((String)"\n"));
                text.method_10852(message);
            }
            ((class_2168)context.getSource()).method_9226(() -> text, false);
            return 1;
        });
    }
}

