/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import me.alexdevs.solstice.Solstice;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class PlayerData {
    protected final UUID uuid;
    protected final Path filePath;
    protected final Path basePath;
    protected final Map<class_2960, Class<?>> classMap = new HashMap();
    protected final Map<Class<?>, Object> data = new HashMap();
    protected final Map<Class<?>, Supplier<?>> providers = new HashMap();
    protected final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").serializeNulls().create();
    protected JsonObject node;

    public PlayerData(Path basePath, UUID uuid, Map<class_2960, Class<?>> classMap, Map<Class<?>, Supplier<?>> providers) {
        this.uuid = uuid;
        this.classMap.putAll(classMap);
        this.providers.putAll(providers);
        this.basePath = basePath;
        this.filePath = basePath.resolve(String.valueOf(uuid) + ".json");
        this.loadData(false);
    }

    public Path getDataPath() {
        return this.filePath;
    }

    public <T> T getData(Class<T> clazz) {
        if (this.data.containsKey(clazz)) {
            return (T)this.data.get(clazz);
        }
        if (this.providers.containsKey(clazz)) {
            Object result = this.providers.get(clazz).get();
            this.data.put(clazz, result);
            return (T)result;
        }
        throw new IllegalArgumentException(clazz.getSimpleName() + " does not exist");
    }

    public void save() {
        for (Map.Entry<class_2960, Class<?>> entry : this.classMap.entrySet()) {
            Object obj = this.data.get(entry.getValue());
            this.node.add(entry.getKey().toString(), this.gson.toJsonTree(obj));
        }
        Path parentDir = this.filePath.getParent();
        String fileName = this.filePath.getFileName().toString();
        if (parentDir.toFile().mkdirs()) {
            Solstice.LOGGER.debug("Players data directory created.");
        }
        try {
            File temp = File.createTempFile(this.uuid.toString() + "-", ".json", parentDir.toFile());
            FileWriter tempWriter = new FileWriter(temp);
            this.gson.toJson((JsonElement)this.node, (Appendable)tempWriter);
            tempWriter.close();
            Path target = this.filePath;
            Path backup = parentDir.resolve(fileName + "_old");
            class_156.method_30626((Path)target, (Path)temp.toPath(), (Path)backup);
        }
        catch (Exception e) {
            Solstice.LOGGER.error("Could not save {}. This will lead to data loss!", (Object)this.filePath, (Object)e);
        }
    }

    public <T> void registerData(class_2960 id, Class<T> clazz, Supplier<T> creator) {
        this.classMap.put(id, clazz);
        this.providers.put(clazz, creator);
    }

    public void loadData(boolean force) {
        if (this.node == null || force) {
            this.node = this.loadNode();
        }
        this.data.clear();
        boolean migrated = false;
        for (Map.Entry<class_2960, Class<?>> entry : this.classMap.entrySet()) {
            String key = entry.getKey().toString();
            JsonElement val = this.node.get(key);
            if (val == null) {
                String legacyKey = entry.getKey().method_12832();
                val = this.node.get(legacyKey);
                this.node.remove(legacyKey);
                this.node.add(key, val);
                migrated = true;
            }
            this.data.put(entry.getValue(), this.get(val, entry.getValue()));
        }
        if (migrated) {
            this.backup();
        }
    }

    protected JsonObject loadNode() {
        JsonObject jsonObject;
        if (!this.filePath.toFile().exists()) {
            return new JsonObject();
        }
        FileReader fr = new FileReader(this.filePath.toFile());
        try {
            JsonReader reader = this.gson.newJsonReader((Reader)fr);
            jsonObject = JsonParser.parseReader((JsonReader)reader).getAsJsonObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    fr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Solstice.LOGGER.error("Could not load player data of UUID {}!", (Object)this.uuid, (Object)e);
                this.safeMove();
                return new JsonObject();
            }
        }
        fr.close();
        return jsonObject;
    }

    protected void safeMove() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String date = df.format(new Date());
        Path newPath = this.basePath.resolve(String.format("%s.%s.json", this.uuid, date));
        if (this.filePath.toFile().renameTo(newPath.toFile())) {
            Solstice.LOGGER.warn("{} has been renamed to {}!", (Object)this.filePath, (Object)newPath);
        } else {
            Solstice.LOGGER.error("Could not move file {}. Solstice cannot safely manage player data.", (Object)this.filePath);
        }
    }

    protected <T> T get(@Nullable JsonElement node, Class<T> clazz) {
        if (node == null) {
            return (T)this.providers.get(clazz).get();
        }
        return (T)this.gson.fromJson(node, clazz);
    }

    protected void backup() {
        Path path = this.getDataPath();
        Path parentDir = path.getParent();
        Path fileName = path.getFileName();
        Path backup = parentDir.resolve(fileName.toString() + "_backup");
        if (path.toFile().renameTo(backup.toFile())) {
            Solstice.LOGGER.warn("The player data file has been migrated and the original {} has been renamed to {}!", (Object)path, (Object)backup);
        } else {
            Solstice.LOGGER.error("Could not create backup of player data file!");
        }
    }
}

