/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.integrations;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.events.SolsticeEvents;
import me.alexdevs.solstice.integrations.ConnectorIntegration;
import me.lucko.fabric.api.permissions.v0.OfflinePermissionCheckEvent;
import me.lucko.fabric.api.permissions.v0.PermissionCheckEvent;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.cacheddata.CachedPermissionData;
import net.luckperms.api.event.EventBus;
import net.luckperms.api.event.node.NodeAddEvent;
import net.luckperms.api.event.node.NodeClearEvent;
import net.luckperms.api.event.node.NodeRemoveEvent;
import net.luckperms.api.event.user.UserDataRecalculateEvent;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.util.Tristate;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class LuckPermsIntegration {
    private static LuckPerms luckPerms;
    private static boolean available;
    private static final Map<UUID, Optional<String>> prefixMap;
    private static final Map<UUID, Optional<String>> suffixMap;

    public static void register() {
        if (!LuckPermsIntegration.isAvailable()) {
            Solstice.LOGGER.warn("LuckPerms not available! It is recommended to install LuckPerms to configure permissions and groups.");
            return;
        }
        ModContainer container = (ModContainer)FabricLoader.getInstance().getModContainer("solstice").get();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            luckPerms = LuckPermsProvider.get();
            available = true;
            EventBus eventBus = luckPerms.getEventBus();
            if (!ConnectorIntegration.isForge()) {
                eventBus.subscribe((Object)container, UserDataRecalculateEvent.class, Listeners::onDataRecalculate);
                eventBus.subscribe((Object)container, NodeAddEvent.class, Listeners::onNodeAdded);
                eventBus.subscribe((Object)container, NodeRemoveEvent.class, Listeners::onNodeRemoved);
                eventBus.subscribe((Object)container, NodeClearEvent.class, Listeners::onNodeCleared);
            } else {
                eventBus.subscribe(UserDataRecalculateEvent.class, Listeners::onDataRecalculate);
                eventBus.subscribe(NodeAddEvent.class, Listeners::onNodeAdded);
                eventBus.subscribe(NodeRemoveEvent.class, Listeners::onNodeRemoved);
                eventBus.subscribe(NodeClearEvent.class, Listeners::onNodeCleared);
                Solstice.LOGGER.warn("Permissions API is not available. Solstice is now taking over!");
                PermissionCheckEvent.EVENT.register((suggestion, permission) -> {
                    class_2168 stack = (class_2168)suggestion;
                    class_1297 entity = stack.method_9228();
                    Tristate result = LuckPermsIntegration.checkPermission(entity, permission);
                    return switch (result) {
                        default -> throw new MatchException(null, null);
                        case Tristate.TRUE -> TriState.TRUE;
                        case Tristate.FALSE -> TriState.FALSE;
                        case Tristate.UNDEFINED -> TriState.DEFAULT;
                    };
                });
                OfflinePermissionCheckEvent.EVENT.register((uuid, permission) -> {
                    CompletableFuture future = new CompletableFuture();
                    LuckPermsIntegration.checkPermission(uuid, permission).thenAcceptAsync(result -> future.complete(switch (result) {
                        default -> throw new MatchException(null, null);
                        case Tristate.TRUE -> TriState.TRUE;
                        case Tristate.FALSE -> TriState.FALSE;
                        case Tristate.UNDEFINED -> TriState.DEFAULT;
                    }));
                    return future;
                });
            }
        });
        SolsticeEvents.RELOAD.register(event -> {
            prefixMap.clear();
            suffixMap.clear();
        });
    }

    public static boolean isAvailable() {
        return FabricLoader.getInstance().isModLoaded("luckperms");
    }

    @Nullable
    public static String getPrefix(class_3222 player) {
        if (!available) {
            return null;
        }
        return prefixMap.computeIfAbsent(player.method_5667(), uuid -> {
            try {
                CachedMetaData playerMeta = luckPerms.getPlayerAdapter(class_3222.class).getMetaData((Object)player);
                return Optional.ofNullable(playerMeta.getPrefix());
            }
            catch (IllegalStateException e) {
                return Optional.empty();
            }
        }).orElse(null);
    }

    @Nullable
    public static String getSuffix(class_3222 player) {
        if (!available) {
            return null;
        }
        return suffixMap.computeIfAbsent(player.method_5667(), uuid -> {
            try {
                CachedMetaData playerMeta = luckPerms.getPlayerAdapter(class_3222.class).getMetaData((Object)player);
                return Optional.ofNullable(playerMeta.getSuffix());
            }
            catch (IllegalStateException e) {
                return Optional.empty();
            }
        }).orElse(null);
    }

    public static boolean isInGroup(class_3222 player, String group) {
        if (!available) {
            return "default".equals(group);
        }
        try {
            User user = luckPerms.getPlayerAdapter(class_3222.class).getUser((Object)player);
            Collection inheritedGroups = user.getInheritedGroups(user.getQueryOptions());
            return inheritedGroups.stream().anyMatch(g -> g.getName().equalsIgnoreCase(group));
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static String getPrimaryGroup(class_3222 player) {
        if (!available) {
            return "default";
        }
        try {
            User user = luckPerms.getPlayerAdapter(class_3222.class).getUser((Object)player);
            return user.getPrimaryGroup();
        }
        catch (IllegalStateException e) {
            return "default";
        }
    }

    public static Tristate checkPermission(class_1297 entity, String permission) {
        if (!(entity instanceof class_3222)) {
            return Tristate.UNDEFINED;
        }
        User user = luckPerms.getPlayerAdapter(class_3222.class).getUser((Object)((class_3222)entity));
        CachedPermissionData perms = user.getCachedData().getPermissionData();
        return perms.checkPermission(permission);
    }

    public static CompletableFuture<Tristate> checkPermission(UUID uuid, String permission) {
        CompletableFuture<Tristate> future = new CompletableFuture<Tristate>();
        if (luckPerms.getUserManager().isLoaded(uuid)) {
            User user2 = luckPerms.getUserManager().getUser(uuid);
            if (user2 == null) {
                future.complete(Tristate.UNDEFINED);
            } else {
                future.complete(user2.getCachedData().getPermissionData().checkPermission(permission));
            }
        } else {
            luckPerms.getUserManager().loadUser(uuid).thenAccept(user -> future.complete(user.getCachedData().getPermissionData().checkPermission(permission)));
        }
        return future;
    }

    public static void clearUserCache(UUID uuid) {
        prefixMap.remove(uuid);
        suffixMap.remove(uuid);
    }

    public static void recalculateUsersCache() {
        Solstice.server.method_3760().method_14571().forEach(player -> {
            LuckPermsIntegration.getPrefix(player);
            LuckPermsIntegration.getSuffix(player);
        });
    }

    static {
        available = false;
        prefixMap = new ConcurrentHashMap<UUID, Optional<String>>();
        suffixMap = new ConcurrentHashMap<UUID, Optional<String>>();
    }

    public static class Listeners {
        public static void onDataRecalculate(UserDataRecalculateEvent event) {
            UUID uuid = event.getUser().getUniqueId();
            LuckPermsIntegration.clearUserCache(uuid);
        }

        public static void onNodeAdded(NodeAddEvent event) {
            if (event.isGroup()) {
                Solstice.scheduler.scheduleSync(() -> {
                    if (event.getNode().getType() == NodeType.PREFIX) {
                        prefixMap.clear();
                    } else if (event.getNode().getType() == NodeType.SUFFIX) {
                        suffixMap.clear();
                    }
                    LuckPermsIntegration.recalculateUsersCache();
                }, 50L, TimeUnit.MILLISECONDS);
            }
        }

        public static void onNodeRemoved(NodeRemoveEvent event) {
            if (event.isGroup()) {
                Solstice.scheduler.scheduleSync(() -> {
                    if (event.getNode().getType() == NodeType.PREFIX) {
                        prefixMap.clear();
                    } else if (event.getNode().getType() == NodeType.SUFFIX) {
                        suffixMap.clear();
                    }
                    LuckPermsIntegration.recalculateUsersCache();
                }, 50L, TimeUnit.MILLISECONDS);
            }
        }

        public static void onNodeCleared(NodeClearEvent event) {
            if (event.isGroup()) {
                Solstice.scheduler.scheduleSync(() -> {
                    prefixMap.clear();
                    suffixMap.clear();
                    LuckPermsIntegration.recalculateUsersCache();
                }, 50L, TimeUnit.MILLISECONDS);
            }
        }
    }
}

