/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.locale;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.locale.Locale;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class LocaleManager {
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().setDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").create();
    private static final Pattern sharedRegex = Pattern.compile("^shared\\.(.+)$");
    private static final Pattern moduleRegex = Pattern.compile("^module\\.(\\w+\\.\\w+)\\.(.+)$");
    private final Path path;
    private final TypeToken<?> oldType = TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, String.class});
    private final LocaleModel defaultMap = new LocaleModel();
    private LocaleModel locale;
    private Map<String, String> localeMap;

    public LocaleManager(Path path) {
        this.path = path;
    }

    @Nullable
    public static LocalePath getPath(String fullPath) {
        Matcher matcher = sharedRegex.matcher(fullPath);
        if (matcher.find()) {
            String key = matcher.group(1);
            return new LocalePath(LocaleType.SHARED, key);
        }
        matcher = moduleRegex.matcher(fullPath);
        if (matcher.find()) {
            String moduleId = matcher.group(1);
            String key = matcher.group(2);
            return new LocalePath(LocaleType.MODULE, key, moduleId);
        }
        return null;
    }

    public Locale getLocale(class_2960 id) {
        return new Locale(id, () -> this.localeMap);
    }

    public Locale getShared() {
        return new Locale(Solstice.ID.method_45136("shared"), () -> this.localeMap);
    }

    public void registerModule(class_2960 id, Map<String, String> defaults) {
        String key = id.toString().replace(":", ".");
        this.defaultMap.modules.put(key, new ConcurrentHashMap<String, String>(defaults));
    }

    public void registerShared(Map<String, String> defaults) {
        this.defaultMap.shared.putAll(defaults);
    }

    public void load() throws IOException {
        if (!this.path.toFile().exists()) {
            this.locale = new LocaleModel();
            this.prepare();
            this.localeMap = this.generateMap();
            return;
        }
        BufferedReader bf = new BufferedReader(new FileReader(this.path.toFile(), StandardCharsets.UTF_8));
        this.locale = (LocaleModel)gson.fromJson((Reader)bf, LocaleModel.class);
        bf.close();
        if (this.locale.shared.isEmpty() && this.locale.modules.isEmpty()) {
            Solstice.LOGGER.warn("Locale casting failure. Attempting migration...");
            this.migrate();
        }
        this.migrateIdentifier();
        this.prepare();
        this.localeMap = this.generateMap();
    }

    public void save() throws IOException {
        FileWriter fw = new FileWriter(this.path.toFile(), StandardCharsets.UTF_8);
        gson.toJson((Object)this.locale, (Appendable)fw);
        fw.close();
    }

    private void prepare() {
        if (this.locale == null) {
            return;
        }
        this.defaultMap.shared.forEach((key, value) -> this.locale.shared.putIfAbsent((String)key, (String)value));
        for (Map.Entry<String, ConcurrentHashMap<String, String>> defaultMods : this.defaultMap.modules.entrySet()) {
            ConcurrentHashMap module = this.locale.modules.computeIfAbsent(defaultMods.getKey(), id -> new ConcurrentHashMap());
            for (Map.Entry<String, String> modLocale : this.defaultMap.modules.get(defaultMods.getKey()).entrySet()) {
                module.putIfAbsent(modLocale.getKey(), modLocale.getValue());
            }
        }
    }

    private void migrate() {
        this.locale = new LocaleModel();
        try {
            BufferedReader bf = new BufferedReader(new FileReader(this.path.toFile(), StandardCharsets.UTF_8));
            Map oldLocale = (Map)gson.fromJson((Reader)bf, this.oldType);
            for (Map.Entry entry : oldLocale.entrySet()) {
                LocalePath path = LocaleManager.getPath((String)entry.getKey());
                if (path == null) {
                    Solstice.LOGGER.warn("Invalid locale node: {}", entry.getKey());
                    continue;
                }
                if (path.type() == LocaleType.SHARED) {
                    this.locale.shared.put(path.key(), (String)entry.getValue());
                    continue;
                }
                if (path.type() != LocaleType.MODULE) continue;
                this.locale.modules.computeIfAbsent(path.moduleId(), key -> new ConcurrentHashMap()).put(path.key(), (String)entry.getValue());
            }
            bf.close();
            Solstice.LOGGER.info("Successfully migrated locale!");
        }
        catch (JsonSyntaxException | IOException e) {
            Solstice.LOGGER.error("Could not load locale", e);
        }
    }

    private void migrateIdentifier() {
        boolean migrated = false;
        for (Map.Entry<String, ConcurrentHashMap<String, String>> entry : this.locale.modules.entrySet()) {
            String key = entry.getKey();
            if (key.contains(".")) continue;
            String newKey = Solstice.ID.method_45136(key).toString().replace(':', '.');
            this.locale.modules.put(newKey, entry.getValue());
            this.locale.modules.remove(key);
            migrated = true;
        }
        if (migrated) {
            this.backup();
        }
    }

    public Map<String, String> generateMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.locale.shared.entrySet()) {
            map.put("shared." + entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.locale.modules.entrySet()) {
            for (Map.Entry entry2 : ((ConcurrentHashMap)entry.getValue()).entrySet()) {
                map.put("module." + entry.getKey() + "." + (String)entry2.getKey(), (String)entry2.getValue());
            }
        }
        return map;
    }

    public void reload() throws IOException {
        this.load();
        this.save();
    }

    protected void backup() {
        Path parentDir = this.path.getParent();
        Path fileName = this.path.getFileName();
        Path backup = parentDir.resolve(fileName.toString() + "_backup");
        if (this.path.toFile().renameTo(backup.toFile())) {
            Solstice.LOGGER.warn("The locale file has been migrated and the original {} has been renamed to {}!", (Object)this.path, (Object)backup);
        } else {
            Solstice.LOGGER.error("Could not create backup of locale file!");
        }
    }

    public static class LocaleModel {
        public int version = 3;
        public ConcurrentHashMap<String, String> shared = new ConcurrentHashMap();
        public ConcurrentHashMap<String, ConcurrentHashMap<String, String>> modules = new ConcurrentHashMap();
    }

    public static final class LocalePath {
        private final LocaleType type;
        private final String key;
        @Nullable
        private final String moduleId;

        public LocalePath(LocaleType type, String key, @Nullable String moduleId) {
            this.type = type;
            this.key = key;
            this.moduleId = moduleId;
        }

        public LocalePath(LocaleType type, String key) {
            this(type, key, null);
        }

        public LocaleType type() {
            return this.type;
        }

        public String key() {
            return this.key;
        }

        @Nullable
        public String moduleId() {
            return this.moduleId;
        }
    }

    public static enum LocaleType {
        SHARED,
        MODULE;

    }
}

