/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.afk;

import com.mojang.authlib.GameProfile;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.ServerLocation;
import me.alexdevs.solstice.api.events.CommandEvents;
import me.alexdevs.solstice.api.events.PlayerActivityEvents;
import me.alexdevs.solstice.api.events.SolsticeEvents;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.api.text.Format;
import me.alexdevs.solstice.core.UserCache;
import me.alexdevs.solstice.modules.afk.commands.ActiveTimeCommand;
import me.alexdevs.solstice.modules.afk.commands.AfkCommand;
import me.alexdevs.solstice.modules.afk.data.AfkConfig;
import me.alexdevs.solstice.modules.afk.data.AfkLocale;
import me.alexdevs.solstice.modules.afk.data.AfkPlayerData;
import me.alexdevs.solstice.modules.afk.data.AfkServerData;
import me.alexdevs.solstice.modules.afk.data.LeaderboardEntry;
import me.alexdevs.solstice.modules.afk.data.PlayerActivityState;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class AfkModule
extends ModuleBase.Toggleable {
    public static final double sprintSpeed = 0.280617;
    public static final double walkSpeed = 0.215859;
    public static final double sneakSpeed = 0.0841;
    public static final int LEADERBOARD_SIZE = 10;
    private final Map<UUID, PlayerActivityState> activities = new ConcurrentHashMap<UUID, PlayerActivityState>();

    public AfkModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        this.registerConfig(AfkConfig.class, AfkConfig::new);
        this.registerLocale(AfkLocale.MODULE);
        this.registerPlayerData(AfkPlayerData.class, AfkPlayerData::new);
        this.registerServerData(AfkServerData.class, AfkServerData::new);
        this.commands.add(new AfkCommand(this));
        this.commands.add(new ActiveTimeCommand(this));
        Placeholders.register((class_2960)class_2960.method_60655((String)"solstice", (String)"afk"), (context, arg) -> {
            if (!context.hasPlayer()) {
                return PlaceholderResult.invalid((String)"No player!");
            }
            class_3222 player = context.player();
            if (this.isPlayerAfk(player)) {
                return PlaceholderResult.value((class_2561)Format.parse(this.getConfig().tag));
            }
            return PlaceholderResult.value((String)"");
        });
        SolsticeEvents.READY.register((instance, server) -> {
            Solstice.scheduler.scheduleAtFixedRate(this::updateActiveTime, 0L, 1L, TimeUnit.SECONDS);
            this.calculateLeaderboard();
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> this.activities.put(handler.method_32311().method_5667(), new PlayerActivityState(handler.method_32311(), server.method_3780())));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> this.activities.remove(handler.method_32311().method_5667()));
        ServerTickEvents.END_SERVER_TICK.register(this::tick);
        PlayerActivityEvents.AFK.register(player -> {
            AfkConfig config = this.getConfig();
            if (player.method_51469().method_33144()) {
                player.method_51469().method_8448();
            }
            Solstice.LOGGER.info("{} is AFK. Active time: {} seconds.", (Object)player.method_7334().getName(), (Object)this.getActiveTime(player.method_5667()));
            if (!config.announce) {
                return;
            }
            PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
            Solstice.getInstance().broadcast(this.locale().get("goneAfk", playerContext));
        });
        PlayerActivityEvents.AFK_RETURN.register((player, reason) -> {
            AfkConfig config = this.getConfig();
            if (player.method_51469().method_33144()) {
                player.method_51469().method_8448();
            }
            Solstice.LOGGER.info("{} is no longer AFK due to {}. Active time: {} seconds.", new Object[]{player.method_7334().getName(), reason.name(), this.getActiveTime(player.method_5667())});
            if (!config.announce) {
                return;
            }
            PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
            Solstice.getInstance().broadcast(this.locale().get("returnAfk", playerContext));
        });
        this.registerTriggers();
    }

    public AfkServerData getServerData() {
        return Solstice.serverData.getData(AfkServerData.class);
    }

    private void updateActiveTime() {
        Stream<class_3222> activePlayers = Solstice.server.method_3760().method_14571().stream().filter(player -> !this.isPlayerAfk((class_3222)player));
        activePlayers.forEach(player -> {
            PlayerActivityState activity = this.activities.computeIfAbsent(player.method_5667(), uuid -> new PlayerActivityState((class_3222)player, player.method_5682().method_3780()));
            if (!activity.activeTimeEnabled) {
                return;
            }
            AfkPlayerData playerData = this.getPlayerData(player.method_5667());
            ++playerData.activeTime;
            this.tryInsertLeaderboard((class_3222)player, playerData.activeTime);
        });
    }

    private void tryInsertLeaderboard(class_3222 player, int activeTime) {
        AfkServerData serverData = this.getServerData();
        List<LeaderboardEntry> leaderboard = serverData.leaderboard;
        Optional<LeaderboardEntry> entry = leaderboard.stream().filter(e -> e.uuid().equals(player.method_5667())).findFirst();
        if (entry.isPresent()) {
            entry.get().activeTime(activeTime);
            entry.get().name(player.method_7334().getName());
            leaderboard.sort((o1, o2) -> Integer.compare(o2.activeTime(), o1.activeTime()));
            return;
        }
        Optional<LeaderboardEntry> smallest = leaderboard.stream().min(Comparator.comparingInt(LeaderboardEntry::activeTime));
        if (smallest.isPresent()) {
            if (smallest.get().activeTime() < activeTime) {
                leaderboard.remove(smallest.get());
                leaderboard.add(new LeaderboardEntry(player.method_7334().getName(), player.method_5667(), activeTime));
                leaderboard.sort((o1, o2) -> Integer.compare(o2.activeTime(), o1.activeTime()));
            }
        } else {
            leaderboard.add(new LeaderboardEntry(player.method_7334().getName(), player.method_5667(), activeTime));
        }
    }

    private void tick(MinecraftServer server) {
        AfkConfig config = this.getConfig();
        if (!config.enable) {
            return;
        }
        server.method_3760().method_14571().forEach(player -> {
            int ticks;
            PlayerActivityState activity = this.activities.computeIfAbsent(player.method_5667(), uuid -> new PlayerActivityState((class_3222)player, server.method_3780()));
            ServerLocation curLocation = new ServerLocation((class_3222)player);
            ServerLocation oldLocation = activity.location;
            activity.location = curLocation;
            class_243 delta = curLocation.getDelta(oldLocation);
            class_243 horizontalDelta = new class_243(delta.method_10216(), 0.0, delta.method_10215());
            double speed = horizontalDelta.method_1033();
            if (player.method_5854() == null && (player.method_5715() && speed >= 0.0841 || player.method_5624() && speed >= 0.280617 || speed >= 0.215859) && this.getConfig().triggers.onMovement) {
                this.clearAfk((class_3222)player, AfkTriggerReason.MOVEMENT);
            }
            if ((curLocation.getPitch() != oldLocation.getPitch() || curLocation.getYaw() != oldLocation.getYaw()) && this.getConfig().triggers.onLookChange) {
                this.clearAfk((class_3222)player, AfkTriggerReason.LOOK_CHANGE);
            }
            if (activity.lastUpdate < (ticks = server.method_3780()) - config.timeTrigger * 20 && !activity.isAfk && activity.afkEnabled) {
                activity.isAfk = true;
                ((PlayerActivityEvents.Afk)PlayerActivityEvents.AFK.invoker()).onAfk((class_3222)player);
            }
        });
    }

    public AfkConfig getConfig() {
        return Solstice.configManager.getData(AfkConfig.class);
    }

    public AfkPlayerData getPlayerData(UUID playerUuid) {
        return Solstice.playerData.get(playerUuid).getData(AfkPlayerData.class);
    }

    public boolean isPlayerAfk(class_3222 player) {
        return this.activities.containsKey(player.method_5667()) && this.activities.get((Object)player.method_5667()).isAfk;
    }

    public void setPlayerAfk(class_3222 player, boolean isAfk) {
        if (!this.activities.containsKey(player.method_5667())) {
            return;
        }
        AfkConfig config = this.getConfig();
        PlayerActivityState activity = this.activities.get(player.method_5667());
        if (isAfk) {
            activity.lastUpdate -= config.timeTrigger * 20;
        } else {
            this.clearAfk(player, AfkTriggerReason.MANUAL);
        }
    }

    public int getActiveTime(UUID playerUuid) {
        return this.getPlayerData((UUID)playerUuid).activeTime;
    }

    public void forceRecalculateLeaderboard() {
        this.getServerData().forceCalculateLeaderboard = true;
        this.calculateLeaderboard();
    }

    private void calculateLeaderboard() {
        AfkServerData serverData = this.getServerData();
        if (!serverData.forceCalculateLeaderboard) {
            return;
        }
        serverData.forceCalculateLeaderboard = false;
        UserCache userCache = Solstice.getUserCache();
        ArrayList<LeaderboardEntry> temp = new ArrayList<LeaderboardEntry>();
        for (String name : userCache.getAllNames()) {
            Optional<GameProfile> profile = userCache.getByName(name);
            if (profile.isEmpty()) continue;
            AfkPlayerData playerData = Solstice.playerData.get(profile.get().getId()).getData(AfkPlayerData.class);
            if (playerData.activeTime <= 0) continue;
            LeaderboardEntry entry = new LeaderboardEntry(profile.get().getName(), profile.get().getId(), playerData.activeTime);
            temp.add(entry);
        }
        temp.sort((o1, o2) -> Integer.compare(o2.activeTime(), o1.activeTime()));
        serverData.leaderboard.clear();
        for (int i = 0; i < Math.min(temp.size(), 10); ++i) {
            serverData.leaderboard.add((LeaderboardEntry)temp.get(i));
        }
        List<UUID> onlinePlayers = Solstice.server.method_3760().method_14571().stream().map(class_1297::method_5667).toList();
        Solstice.playerData.disposeMissing(onlinePlayers);
    }

    public List<LeaderboardEntry> getActiveTimeLeaderboard() {
        AfkServerData serverData = this.getServerData();
        return Collections.unmodifiableList(serverData.leaderboard);
    }

    public List<class_3222> getCurrentActivePlayers() {
        return Solstice.server.method_3760().method_14571().stream().filter(player -> !this.isPlayerAfk((class_3222)player)).toList();
    }

    private void clearAfk(class_3222 player, AfkTriggerReason reason) {
        if (!this.activities.containsKey(player.method_5667())) {
            return;
        }
        PlayerActivityState activity = this.activities.get(player.method_5667());
        activity.lastUpdate = Solstice.server.method_3780();
        if (!activity.afkEnabled) {
            return;
        }
        if (activity.isAfk) {
            activity.isAfk = false;
            ((PlayerActivityEvents.AfkReturn)PlayerActivityEvents.AFK_RETURN.invoker()).onAfkReturn(player, reason);
        }
    }

    private void registerTriggers() {
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            if (this.getConfig().triggers.onBlockAttack) {
                this.clearAfk((class_3222)player, AfkTriggerReason.BLOCK_ATTACK);
            }
            return class_1269.field_5811;
        });
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            if (this.getConfig().triggers.onEntityAttack) {
                this.clearAfk((class_3222)player, AfkTriggerReason.ENTITY_ATTACK);
            }
            return class_1269.field_5811;
        });
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (this.getConfig().triggers.onBlockInteract) {
                this.clearAfk((class_3222)player, AfkTriggerReason.BLOCK_INTERACT);
            }
            return class_1269.field_5811;
        });
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            if (this.getConfig().triggers.onEntityInteract) {
                this.clearAfk((class_3222)player, AfkTriggerReason.ENTITY_INTERACT);
            }
            return class_1269.field_5811;
        });
        UseItemCallback.EVENT.register((player, world, hand) -> {
            if (this.getConfig().triggers.onItemUse) {
                this.clearAfk((class_3222)player, AfkTriggerReason.ITEM_USE);
            }
            return class_1271.method_22430((Object)player.method_5998(hand));
        });
        ServerMessageEvents.ALLOW_CHAT_MESSAGE.register((message, sender, params) -> {
            if (this.getConfig().triggers.onChat) {
                this.clearAfk(sender, AfkTriggerReason.CHAT_MESSAGE);
            }
            return true;
        });
        CommandEvents.ALLOW_COMMAND.register((source, command) -> {
            if (!source.method_43737()) {
                return true;
            }
            if (this.getConfig().triggers.onCommand) {
                this.clearAfk(source.method_44023(), AfkTriggerReason.COMMAND);
            }
            return true;
        });
    }

    public static enum AfkTriggerReason {
        MANUAL,
        MOVEMENT,
        LOOK_CHANGE,
        CHAT_MESSAGE,
        COMMAND,
        BLOCK_ATTACK,
        BLOCK_INTERACT,
        ENTITY_ATTACK,
        ENTITY_INTERACT,
        ITEM_USE;

    }
}

