/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.announcement;

import eu.pb4.placeholders.api.PlaceholderContext;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.events.SolsticeEvents;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.api.text.Format;
import me.alexdevs.solstice.modules.announcement.data.AnnouncementConfig;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class AnnouncementModule
extends ModuleBase.Toggleable {
    private ScheduledFuture<?> scheduledFuture = null;
    private int currentLine = 0;

    public AnnouncementModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        this.registerConfig(AnnouncementConfig.class, AnnouncementConfig::new);
        SolsticeEvents.READY.register((instance, server) -> this.setup());
        SolsticeEvents.RELOAD.register(instance -> {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
            }
            this.setup();
        });
    }

    private void setup() {
        this.currentLine = 0;
        if (this.getConfig().enable) {
            this.scheduledFuture = Solstice.scheduler.scheduleAtFixedRate(this::announce, this.getConfig().delay, this.getConfig().delay, TimeUnit.SECONDS);
        }
    }

    public AnnouncementConfig getConfig() {
        return Solstice.configManager.getData(AnnouncementConfig.class);
    }

    public void announce() {
        ArrayList<AnnouncementConfig.Announcement> lines = this.getConfig().announcements;
        if (lines.isEmpty()) {
            return;
        }
        if (this.getConfig().pickRandomly) {
            this.currentLine = new Random().nextInt(lines.size());
        }
        this.currentLine %= lines.size();
        AnnouncementConfig.Announcement line = lines.get(this.currentLine);
        ++this.currentLine;
        Solstice.server.method_3760().method_14571().forEach(player -> {
            if (line.permission() != null) {
                Boolean result = line.result();
                if (result == null) {
                    result = true;
                }
                if (Permissions.check((class_1297)player, (String)line.permission()) != result) {
                    return;
                }
            }
            PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
            player.method_43496(Format.parse(line.text(), playerContext));
        });
    }
}

