/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.cooldown;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.command.TimeSpan;
import me.alexdevs.solstice.api.events.ModuleCommandEvents;
import me.alexdevs.solstice.api.events.SolsticeEvents;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.modules.cooldown.commands.CooldownCommand;
import me.alexdevs.solstice.modules.cooldown.data.CooldownConfig;
import me.alexdevs.solstice.modules.cooldown.data.CooldownLocale;
import me.alexdevs.solstice.modules.cooldown.data.CooldownSetting;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class CooldownModule
extends ModuleBase.Toggleable {
    public static final String PERMISSION_BASE = "solstice.cooldown";
    private final Map<UUID, Map<String, Integer>> cooldowns = new ConcurrentHashMap<UUID, Map<String, Integer>>();
    private Map<String, String> nodesMap = Map.of();

    public CooldownModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        this.registerConfig(CooldownConfig.class, CooldownConfig::new);
        this.registerLocale(CooldownLocale.MODULE);
        this.commands.add(new CooldownCommand(this));
        SolsticeEvents.READY.register((instance, server) -> this.reloadNodes());
        SolsticeEvents.RELOAD.register(instance -> this.reloadNodes());
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            UUID playerUuid = handler.method_32311().method_5667();
            this.cooldowns.computeIfAbsent(playerUuid, k -> new ConcurrentHashMap());
        });
        Solstice.scheduler.scheduleAtFixedRate(this::tickDown, 0L, 1L, TimeUnit.SECONDS);
        ModuleCommandEvents.ALLOW_COMMAND.register((node, context, command) -> {
            if (!((class_2168)context.getSource()).method_43737()) {
                return true;
            }
            Solstice.LOGGER.debug("Node: {}", (Object)node);
            Optional<CooldownSetting> setting = this.findSetting(node);
            if (setting.isEmpty()) {
                return true;
            }
            String key = setting.get().getKey();
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (this.isExempt(player, key)) {
                return true;
            }
            boolean isOnCooldown = this.onCooldown(player, key);
            if (isOnCooldown) {
                class_2561 message = this.getMessage(player, key);
                ((class_2168)context.getSource()).method_9213(message);
            }
            return !isOnCooldown;
        });
        ModuleCommandEvents.COMMAND.register((node, context, command) -> {
            String key;
            if (!((class_2168)context.getSource()).method_43737()) {
                return;
            }
            Optional<CooldownSetting> setting = this.findSetting(node);
            if (setting.isEmpty()) {
                return;
            }
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (this.isExempt(player, key = setting.get().getKey())) {
                return;
            }
            this.trigger(player, key, setting.get().cooldown);
        });
    }

    private void reloadNodes() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, CooldownSetting> entry : this.getConfig().nodes.entrySet()) {
            String key = entry.getKey();
            CooldownSetting setting = entry.getValue();
            setting.setKey(key);
            for (String node : setting.nodes) {
                map.put(node, key);
            }
        }
        this.nodesMap = map;
    }

    public CooldownConfig getConfig() {
        return Solstice.configManager.getData(CooldownConfig.class);
    }

    private static String getParent(String node) {
        String[] chunks = node.split("\\.");
        if (chunks.length <= 1) {
            return "";
        }
        CharSequence[] sliced = Arrays.copyOf(chunks, chunks.length - 1);
        return String.join((CharSequence)".", sliced);
    }

    public Optional<CooldownSetting> findSetting(String originalNode) {
        String parent;
        if (this.nodesMap.containsKey(originalNode)) {
            String key = this.nodesMap.get(originalNode);
            return Optional.of(this.getConfig().nodes.get(key));
        }
        String node = originalNode;
        do {
            String wildcard;
            if (this.nodesMap.containsKey(wildcard = (parent = CooldownModule.getParent(node)) + ".*")) {
                String key = this.nodesMap.get(wildcard);
                this.nodesMap.put(originalNode, key);
                return Optional.of(this.getConfig().nodes.get(key));
            }
            node = parent;
        } while (!parent.isEmpty());
        return Optional.empty();
    }

    private void tickDown() {
        for (Map.Entry<UUID, Map<String, Integer>> entry : this.cooldowns.entrySet()) {
            for (Map.Entry<String, Integer> cdEntry : entry.getValue().entrySet()) {
                int val = cdEntry.getValue() - 1;
                if (val <= 0) {
                    entry.getValue().remove(cdEntry.getKey());
                    continue;
                }
                cdEntry.setValue(val);
            }
        }
    }

    public boolean isExempt(class_3222 player, String key) {
        return Permissions.check((class_1297)player, (String)("solstice.cooldown.exempt." + key), (int)3);
    }

    public boolean onCooldown(class_3222 player, String key) {
        if (this.isExempt(player, key)) {
            return false;
        }
        UUID uuid = player.method_5667();
        Map cooldown = this.cooldowns.computeIfAbsent(uuid, k -> new ConcurrentHashMap());
        return cooldown.getOrDefault(key, 0) > 0;
    }

    public Optional<Integer> getCooldown(class_3222 player, String key) {
        UUID uuid = player.method_5667();
        Map cooldown = this.cooldowns.computeIfAbsent(uuid, k -> new ConcurrentHashMap());
        if (!cooldown.containsKey(key)) {
            return Optional.empty();
        }
        Integer value = (Integer)cooldown.get(key);
        return Optional.of(value);
    }

    public class_2561 getMessage(class_3222 player, String key) {
        Optional<Integer> valueOpt = this.getCooldown(player, key);
        return this.locale().get("cooldown", Map.of("timespan", class_2561.method_30163((String)TimeSpan.toShortString(valueOpt.orElse(0)))));
    }

    public boolean trigger(class_3222 player, String key, int seconds) {
        if (this.onCooldown(player, key)) {
            return false;
        }
        if (this.isExempt(player, key)) {
            return true;
        }
        UUID uuid = player.method_5667();
        Map<String, Integer> cooldown = this.cooldowns.get(uuid);
        cooldown.put(key, seconds);
        return true;
    }

    public void clear(class_3222 player, String node) {
        UUID uuid = player.method_5667();
        Map<String, Integer> cooldown = this.cooldowns.get(uuid);
        cooldown.remove(node);
    }

    public List<String> getKeys() {
        return this.getConfig().nodes.keySet().stream().toList();
    }
}

