/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.cooldown.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import me.alexdevs.solstice.api.command.TimeSpan;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.cooldown.CooldownModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class CooldownCommand
extends ModCommand<CooldownModule> {
    public CooldownCommand(CooldownModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("cooldown");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require(1))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").requires(this.require("clear", 3))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).suggests(this::suggestKeys).executes(this::clearCooldown))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"check").requires(this.require("check", 1))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).suggests(this::suggestKeys).executes(this::checkCooldown))));
    }

    private CompletableFuture<Suggestions> suggestKeys(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(((CooldownModule)this.module).getKeys(), (SuggestionsBuilder)builder);
    }

    private int clearCooldown(CommandContext<class_2168> context) throws CommandSyntaxException {
        String key;
        class_3222 player = class_2186.method_9315(context, (String)"player");
        if (((CooldownModule)this.module).isExempt(player, key = StringArgumentType.getString(context, (String)"key"))) {
            Map<String, class_5250> placeholders = Map.of("player", player.method_5477(), "key", class_2561.method_43470((String)key));
            ((class_2168)context.getSource()).method_9213(((CooldownModule)this.module).locale().get("exempt", placeholders));
            return 0;
        }
        Optional<Integer> value = ((CooldownModule)this.module).getCooldown(player, key);
        if (value.isEmpty()) {
            Map<String, class_5250> placeholders = Map.of("player", player.method_5477(), "key", class_2561.method_43470((String)key));
            ((class_2168)context.getSource()).method_9213(((CooldownModule)this.module).locale().get("noCooldown", placeholders));
            return 0;
        }
        ((CooldownModule)this.module).clear(player, key);
        Map<String, class_5250> placeholders = Map.of("player", player.method_5477(), "key", class_2561.method_43470((String)key));
        ((class_2168)context.getSource()).method_9226(() -> ((CooldownModule)this.module).locale().get("cleared", placeholders), true);
        return 1;
    }

    private int checkCooldown(CommandContext<class_2168> context) throws CommandSyntaxException {
        String key;
        class_3222 player = class_2186.method_9315(context, (String)"player");
        if (((CooldownModule)this.module).isExempt(player, key = StringArgumentType.getString(context, (String)"key"))) {
            Map<String, class_5250> placeholders = Map.of("player", player.method_5477(), "key", class_2561.method_43470((String)key));
            ((class_2168)context.getSource()).method_9213(((CooldownModule)this.module).locale().get("exempt", placeholders));
            return 0;
        }
        Optional<Integer> value = ((CooldownModule)this.module).getCooldown(player, key);
        if (value.isEmpty()) {
            Map<String, class_5250> placeholders = Map.of("player", player.method_5477(), "key", class_2561.method_43470((String)key));
            ((class_2168)context.getSource()).method_9213(((CooldownModule)this.module).locale().get("noCooldown", placeholders));
            return 0;
        }
        String span = TimeSpan.toShortString(value.get());
        Map<String, class_2561> placeholders = Map.of("player", player.method_5477(), "key", class_2561.method_43470((String)key), "timespan", class_2561.method_30163((String)span));
        ((class_2168)context.getSource()).method_9226(() -> ((CooldownModule)this.module).locale().get("checkResult", placeholders), false);
        return 1;
    }
}

