/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.enderchest.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.List;
import java.util.Map;
import me.alexdevs.solstice.api.command.LocalGameProfile;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.api.utils.PlayerUtils;
import me.alexdevs.solstice.modules.enderchest.EnderChestModule;
import me.alexdevs.solstice.modules.inventorySee.ImmutableSlot;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1730;
import net.minecraft.class_1735;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3917;
import net.minecraft.server.MinecraftServer;

public class EnderChestCommand
extends ModCommand<EnderChestModule> {
    public EnderChestCommand(EnderChestModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("enderchest", "ec");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require(2))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            player.method_7281(class_3468.field_15424);
            this.open(player, player.method_7274(), (class_2561)class_2561.method_43471((String)"container.enderchest"), true, () -> {});
            return 1;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).requires(this.require("others", 2))).suggests(LocalGameProfile::suggest).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = source.method_9207();
            GameProfile profile = LocalGameProfile.getProfile((CommandContext<class_2168>)context, "player");
            Permissions.check((GameProfile)profile, (String)this.getPermissionNode("exempt"), (int)3, (MinecraftServer)source.method_9211()).thenAccept(exempt -> {
                if (exempt.booleanValue()) {
                    source.method_9226(() -> ((EnderChestModule)this.module).locale().get("exempt"), false);
                    return;
                }
                boolean isOnline = PlayerUtils.isOnline(profile.getId());
                if (!isOnline && !Permissions.check((class_1297)player, (String)this.getPermissionNode("offline"), (int)3)) {
                    source.method_9226(() -> ((EnderChestModule)this.module).locale().get("offlineNotAllowed"), false);
                    return;
                }
                class_3222 targetPlayer = isOnline ? source.method_9211().method_3760().method_14602(profile.getId()) : PlayerUtils.loadOfflinePlayer(profile);
                class_1730 inventory = targetPlayer.method_7274();
                boolean canEdit = Permissions.check((class_1297)player, (String)this.getPermissionNode("edit"), (int)3);
                Map<String, class_2561> map = Map.of("player", class_2561.method_30163((String)profile.getName()));
                class_2561 title = ((EnderChestModule)this.module).locale().get("title", map);
                this.open(player, inventory, title, canEdit, () -> {
                    if (!isOnline) {
                        PlayerUtils.saveOfflinePlayer(targetPlayer);
                    }
                });
                source.method_9226(() -> ((EnderChestModule)this.module).locale().get("opened", map), true);
            });
            return 1;
        }));
    }

    private void open(class_3222 player, class_1730 inventory, class_2561 title, boolean canEdit, final Runnable onClose) {
        SimpleGui container = new SimpleGui(this, class_3917.field_17326, player, false){

            public void onClose() {
                onClose.run();
            }
        };
        for (int i = 0; i < inventory.method_5439(); ++i) {
            Object slot = canEdit ? new class_1735((class_1263)inventory, i, 0, 0) : new ImmutableSlot((class_1263)inventory, i, 0, 0);
            container.setSlotRedirect(i, slot);
        }
        container.setTitle(title);
        container.open();
    }
}

