/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.home.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import java.util.List;
import java.util.Map;
import me.alexdevs.solstice.api.ServerLocation;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.api.text.Components;
import me.alexdevs.solstice.modules.home.HomeModule;
import me.alexdevs.solstice.modules.home.data.HomePlayerData;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class HomeCommand
extends ModCommand<HomeModule> {
    public HomeCommand(HomeModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("home");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require(true))).executes(context -> this.execute((CommandContext<class_2168>)context, "home", false))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            HomePlayerData data = ((HomeModule)this.module).getData(player.method_5667());
            return class_2172.method_9264(data.homes.keySet().stream().sorted(), (SuggestionsBuilder)builder);
        }).executes(context -> this.execute((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"name"), false))).then(class_2170.method_9247((String)"force").executes(context -> this.execute((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"name"), true))));
    }

    private int execute(CommandContext<class_2168> context, String name, boolean force) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        HomePlayerData data = ((HomeModule)this.module).getData(player.method_5667());
        PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
        Map<String, class_2561> placeholders = Map.of("home", class_2561.method_30163((String)name));
        if (!data.homes.containsKey(name)) {
            ((class_2168)context.getSource()).method_9226(() -> ((HomeModule)this.module).locale().get("homeNotFound", playerContext, placeholders), false);
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> ((HomeModule)this.module).locale().get("teleporting", playerContext, placeholders), false);
        ServerLocation homePosition = data.homes.get(name);
        if (force) {
            homePosition.teleport(player);
        } else {
            boolean success = homePosition.safeTeleport(player);
            if (!success) {
                Map<String, class_2561> safePlaceholders = Map.of("forceHomeButton", Components.button(((HomeModule)this.module).locale().raw("forceLabel"), ((HomeModule)this.module).locale().raw("forceHover"), "/home " + name + " force"), "home", class_2561.method_30163((String)name));
                ((class_2168)context.getSource()).method_9226(() -> ((HomeModule)this.module).locale().get("teleportFailed", playerContext, safePlaceholders), false);
            }
        }
        return 1;
    }
}

