/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.home.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.placeholders.api.PlaceholderContext;
import java.util.List;
import java.util.Map;
import me.alexdevs.solstice.api.command.LocalGameProfile;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.home.HomeModule;
import me.alexdevs.solstice.modules.home.data.HomePlayerData;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class HomesCommand
extends ModCommand<HomeModule> {
    public HomesCommand(HomeModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("homes");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require(true))).executes(this::execute)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).requires(this.require("others", 2))).suggests(LocalGameProfile::suggest).executes(context -> this.executeOthers((CommandContext<class_2168>)context, LocalGameProfile.getProfile((CommandContext<class_2168>)context, "player"))));
    }

    private int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        HomePlayerData data = ((HomeModule)this.module).getData(player.method_5667());
        List homeList = data.homes.keySet().stream().sorted().toList();
        PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
        if (homeList.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> ((HomeModule)this.module).locale().get("noHomes", playerContext), false);
            return 1;
        }
        class_5250 listText = class_2561.method_43473();
        class_2561 comma = ((HomeModule)this.module).locale().get("homesComma");
        for (int i = 0; i < homeList.size(); ++i) {
            if (i > 0) {
                listText = listText.method_10852(comma);
            }
            Map<String, class_2561> placeholders = Map.of("home", class_2561.method_30163((String)((String)homeList.get(i))));
            listText = listText.method_10852(((HomeModule)this.module).locale().get("homesFormat", playerContext, placeholders));
        }
        Map<String, class_5250> placeholders = Map.of("homeList", listText);
        ((class_2168)context.getSource()).method_9226(() -> ((HomeModule)this.module).locale().get("homeList", playerContext, placeholders), false);
        return homeList.size();
    }

    private int executeOthers(CommandContext<class_2168> context, GameProfile profile) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
        HomePlayerData data = ((HomeModule)this.module).getData(profile.getId());
        List homeList = data.homes.keySet().stream().sorted().toList();
        if (homeList.isEmpty()) {
            Map<String, class_2561> placeholders = Map.of("owner", class_2561.method_30163((String)profile.getName()));
            ((class_2168)context.getSource()).method_9226(() -> ((HomeModule)this.module).locale().get("noHomesOther", playerContext, placeholders), false);
            return 1;
        }
        class_5250 listText = class_2561.method_43473();
        class_2561 comma = ((HomeModule)this.module).locale().get("homesComma");
        for (int i = 0; i < homeList.size(); ++i) {
            if (i > 0) {
                listText = listText.method_10852(comma);
            }
            Map<String, class_2561> placeholders = Map.of("home", class_2561.method_30163((String)((String)homeList.get(i))), "owner", class_2561.method_30163((String)profile.getName()));
            listText = listText.method_10852(((HomeModule)this.module).locale().get("homesFormatOther", playerContext, placeholders));
        }
        Map<String, class_2561> placeholders = Map.of("homeList", listText, "owner", class_2561.method_30163((String)profile.getName()));
        ((class_2168)context.getSource()).method_9226(() -> ((HomeModule)this.module).locale().get("homeListOther", playerContext, placeholders), false);
        return homeList.size();
    }
}

