/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.inventorySee.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.alexdevs.solstice.api.command.LocalGameProfile;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.api.utils.PlayerUtils;
import me.alexdevs.solstice.integrations.TrinketsIntegration;
import me.alexdevs.solstice.modules.inventorySee.ImmutableSlot;
import me.alexdevs.solstice.modules.inventorySee.InventorySeeModule;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class InventorySeeCommand
extends ModCommand<InventorySeeModule> {
    private static final LinkedHashMap<Integer, class_3917<class_1707>> invSizes = new LinkedHashMap();

    public InventorySeeCommand(InventorySeeModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("invsee", "inventorysee");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests(LocalGameProfile::suggest).executes(context -> {
            class_3222 target;
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = source.method_9207();
            GameProfile targetProfile = LocalGameProfile.getProfile((CommandContext<class_2168>)context, "player");
            final boolean targetOnline = PlayerUtils.isOnline(targetProfile.getId());
            if (!targetOnline && !Permissions.check((class_1297)player, (String)this.getPermissionNode("offline"), (int)3)) {
                source.method_9226(() -> ((InventorySeeModule)this.module).locale().get("offlineNotAllowed"), false);
                return 0;
            }
            if (targetOnline) {
                target = ((class_2168)context.getSource()).method_9211().method_3760().method_14602(targetProfile.getId());
                if (Permissions.check((class_1297)target, (String)this.getPermissionNode("exempt"), (int)3)) {
                    source.method_9226(() -> ((InventorySeeModule)this.module).locale().get("exempt"), false);
                    return 0;
                }
            } else {
                target = PlayerUtils.loadOfflinePlayer(targetProfile);
                if (Permissions.check((GameProfile)targetProfile, (String)this.getPermissionNode("exempt"), (int)3, (MinecraftServer)source.method_9211()).getNow(false).booleanValue()) {
                    source.method_9226(() -> ((InventorySeeModule)this.module).locale().get("exempt"), false);
                    return 0;
                }
            }
            boolean canEdit = Permissions.check((class_1297)player, (String)this.getPermissionNode("edit"), (int)3);
            class_1661 targetInventory = target.method_31548();
            SimpleGui container = new SimpleGui(this, class_3917.field_18667, player, false){

                public void onClose() {
                    if (!targetOnline) {
                        PlayerUtils.saveOfflinePlayer(target);
                    }
                }
            };
            for (int i = 0; i < targetInventory.method_5439(); ++i) {
                Object slot = canEdit ? new class_1735((class_1263)targetInventory, i, 0, 0) : new ImmutableSlot((class_1263)targetInventory, i, 0, 0);
                container.setSlotRedirect(i, slot);
            }
            class_1799 barrier = new class_1799((class_1935)class_1802.field_8157);
            barrier.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)""));
            for (int i = targetInventory.method_5439(); i < container.getSize(); ++i) {
                container.setSlot(i, barrier);
            }
            container.setTitle(target.method_5477());
            container.open();
            Map<String, class_2561> map = Map.of("user", class_2561.method_30163((String)target.method_7334().getName()));
            source.method_9226(() -> ((InventorySeeModule)this.module).locale().get("openedInventory", map), true);
            return 1;
        })).then(class_2170.method_9247((String)"trinkets").executes(context -> {
            void var13_18;
            class_3222 target;
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = source.method_9207();
            GameProfile targetProfile = LocalGameProfile.getProfile((CommandContext<class_2168>)context, "player");
            final boolean targetOnline = PlayerUtils.isOnline(targetProfile.getId());
            if (!targetOnline && !Permissions.check((class_1297)player, (String)this.getPermissionNode("offline"), (int)3)) {
                source.method_9226(() -> ((InventorySeeModule)this.module).locale().get("offlineNotAllowed"), false);
                return 0;
            }
            if (targetOnline) {
                target = ((class_2168)context.getSource()).method_9211().method_3760().method_14602(targetProfile.getId());
                if (Permissions.check((class_1297)target, (String)this.getPermissionNode("exempt"), (int)3)) {
                    source.method_9226(() -> ((InventorySeeModule)this.module).locale().get("exempt"), false);
                    return 0;
                }
            } else {
                target = PlayerUtils.loadOfflinePlayer(targetProfile);
                if (Permissions.check((GameProfile)targetProfile, (String)this.getPermissionNode("exempt"), (int)3, (MinecraftServer)source.method_9211()).getNow(false).booleanValue()) {
                    source.method_9226(() -> ((InventorySeeModule)this.module).locale().get("exempt"), false);
                    return 0;
                }
            }
            if (!TrinketsIntegration.isAvailable()) {
                source.method_9226(() -> ((InventorySeeModule)this.module).locale().get("trinketsNotInstalled"), false);
                return 0;
            }
            boolean canEdit = Permissions.check((class_1297)player, (String)this.getPermissionNode("edit"), (int)3);
            TrinketComponent trinkets = TrinketsApi.getTrinketComponent((class_1309)target).orElse(null);
            ArrayList<class_1735> slots = new ArrayList<class_1735>();
            for (Map group : trinkets.getInventory().values()) {
                for (TrinketInventory trinketInventory : group.values()) {
                    for (int i = 0; i < trinketInventory.method_5439(); ++i) {
                        Object slot = canEdit ? new class_1735((class_1263)trinketInventory, i, 0, 0) : new ImmutableSlot((class_1263)trinketInventory, i, 0, 0);
                        slots.add((class_1735)slot);
                    }
                }
            }
            int size = slots.size();
            class_3917 handlerType = null;
            for (Map.Entry entry : invSizes.entrySet()) {
                handlerType = (class_3917)entry.getValue();
                if (size > (Integer)entry.getKey()) continue;
                break;
            }
            SimpleGui container = new SimpleGui(this, handlerType, player, false){

                public void onClose() {
                    if (!targetOnline) {
                        PlayerUtils.saveOfflinePlayer(target);
                    }
                }
            };
            boolean bl = false;
            while (var13_18 < slots.size()) {
                class_1735 slot = (class_1735)slots.get((int)var13_18);
                container.setSlotRedirect((int)var13_18, slot);
                ++var13_18;
            }
            class_1799 class_17992 = new class_1799((class_1935)class_1802.field_8157);
            class_17992.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)""));
            for (int i = size; i < container.getSize(); ++i) {
                container.setSlot(i, class_17992);
            }
            container.setTitle(target.method_5477());
            container.open();
            Map<String, class_2561> map = Map.of("user", class_2561.method_30163((String)target.method_7334().getName()));
            source.method_9226(() -> ((InventorySeeModule)this.module).locale().get("openedTrinkets", map), true);
            return 1;
        })));
    }

    static {
        invSizes.put(9, (class_3917<class_1707>)class_3917.field_18664);
        invSizes.put(18, (class_3917<class_1707>)class_3917.field_18665);
        invSizes.put(27, (class_3917<class_1707>)class_3917.field_17326);
        invSizes.put(36, (class_3917<class_1707>)class_3917.field_18666);
        invSizes.put(45, (class_3917<class_1707>)class_3917.field_18667);
        invSizes.put(54, (class_3917<class_1707>)class_3917.field_17327);
    }
}

