/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.jail;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.ServerLocation;
import me.alexdevs.solstice.api.command.TimeSpan;
import me.alexdevs.solstice.api.events.CommandEvents;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.modules.ModuleProvider;
import me.alexdevs.solstice.modules.jail.commands.CheckJailCommand;
import me.alexdevs.solstice.modules.jail.commands.JailCommand;
import me.alexdevs.solstice.modules.jail.commands.JailsCommand;
import me.alexdevs.solstice.modules.jail.commands.UnjailCommand;
import me.alexdevs.solstice.modules.jail.data.JailConfig;
import me.alexdevs.solstice.modules.jail.data.JailLocale;
import me.alexdevs.solstice.modules.jail.data.JailPlayerData;
import me.alexdevs.solstice.modules.jail.data.JailServerData;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class JailModule
extends ModuleBase.Toggleable {
    public JailModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        this.registerConfig(JailConfig.class, JailConfig::new);
        this.registerLocale(JailLocale.MODULE);
        this.registerPlayerData(JailPlayerData.class, JailPlayerData::new);
        this.registerServerData(JailServerData.class, JailServerData::new);
        this.commands.add(new JailsCommand(this));
        this.commands.add(new JailCommand(this));
        this.commands.add(new UnjailCommand(this));
        this.commands.add(new CheckJailCommand(this));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> Solstice.nextTick(() -> {
            JailPlayerData data = this.getPlayer(handler.method_32311().method_5667());
            if (data.jailed) {
                this.sendToJail(handler.method_32311());
            } else if (data.teleportToPreviousLocation) {
                this.unjailPlayer(handler.method_32311().method_5667());
            }
        }));
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, player, alive) -> {
            if (this.isPlayerJailed(player.method_5667())) {
                this.sendToJail(player);
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> Solstice.scheduler.scheduleAtFixedRate(this::checkJailedPlayers, 0L, 1L, TimeUnit.SECONDS));
        CommandEvents.ALLOW_COMMAND.register((source, command) -> {
            if (!source.method_43737()) {
                return true;
            }
            if (this.isPlayerJailed(source.method_44023().method_5667())) {
                JailConfig config = this.getConfig();
                String cmd = command.split(" ")[0];
                boolean canRun = config.allowedCommands.contains(cmd);
                if (!canRun) {
                    source.method_9226(() -> this.locale().get("cannotRunCommands"), false);
                }
                return canRun;
            }
            return true;
        });
        AttackBlockCallback.EVENT.register((player, world, hand, blockPos, direction) -> {
            if (this.isPlayerJailed(player.method_5667())) {
                player.method_43496(this.locale().get("cannotBreakBlocks"));
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        AttackEntityCallback.EVENT.register((player, world, hand, entity, entityHitResult) -> {
            if (this.isPlayerJailed(player.method_5667())) {
                player.method_43496(this.locale().get("cannotAttackEntities"));
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        PlayerBlockBreakEvents.BEFORE.register((world, player, blockPos, blockState, blockEntity) -> {
            if (this.isPlayerJailed(player.method_5667())) {
                player.method_43496(this.locale().get("cannotBreakBlocks"));
                return false;
            }
            return true;
        });
        UseBlockCallback.EVENT.register((player, world, hand, blockHitResult) -> {
            if (this.isPlayerJailed(player.method_5667())) {
                player.method_43496(this.locale().get("cannotUseBlocks"));
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        UseEntityCallback.EVENT.register((player, world, hand, entity, entityHitResult) -> {
            if (this.isPlayerJailed(player.method_5667())) {
                player.method_43496(this.locale().get("cannotUseEntities"));
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        UseItemCallback.EVENT.register((player, world, hand) -> {
            class_1799 stack = player.method_5998(hand);
            if (this.isPlayerJailed(player.method_5667())) {
                player.method_43496(this.locale().get("cannotUseItems"));
                return class_1271.method_22431((Object)stack);
            }
            return class_1271.method_22430((Object)stack);
        });
        ServerMessageEvents.ALLOW_CHAT_MESSAGE.register((signedMessage, player, parameters) -> {
            if (this.isPlayerJailed(player.method_5667())) {
                JailConfig config = this.getConfig();
                if (config.mute) {
                    player.method_43496(this.locale().get("cannotSpeak"));
                    return false;
                }
            }
            return true;
        });
    }

    private void checkJailedPlayers() {
        Solstice.nextTick(() -> {
            List players = Solstice.server.method_3760().method_14571();
            for (class_3222 player : players) {
                JailPlayerData data = this.getPlayer(player.method_5667());
                if (!this.isPlayerJailed(player.method_5667()) || data.jailTime <= 0 || data.jailedOn == null || data.jailedOn.getTime() + (long)data.jailTime * 1000L >= System.currentTimeMillis()) continue;
                this.unjailPlayer(player.method_5667());
            }
        });
    }

    public JailConfig getConfig() {
        return Solstice.configManager.getData(JailConfig.class);
    }

    public Map<String, ServerLocation> getJails() {
        return Solstice.serverData.getData(JailServerData.class).jails;
    }

    public JailPlayerData getPlayer(UUID uuid) {
        return Solstice.playerData.get(uuid).getData(JailPlayerData.class);
    }

    public boolean isPlayerJailed(UUID uuid) {
        return this.getPlayer((UUID)uuid).jailed;
    }

    public void sendToJail(class_3222 player) {
        Solstice.nextTick(() -> {
            JailPlayerData data = this.getPlayer(player.method_5667());
            Map<String, ServerLocation> jails = this.getJails();
            ServerLocation jail = jails.get(data.jailName);
            if (jail != null) {
                jail.teleport(player);
                Map<String, class_2561> map = Map.of("player", player.method_5477(), "jail", class_2561.method_30163((String)data.jailName), "duration", class_2561.method_30163((String)TimeSpan.toLongString(data.jailTime)), "reason", class_2561.method_30163((String)data.jailReason));
                class_2561 text = data.jailTime > 0 ? (data.jailReason != null ? this.locale().get("playerJailedForWithReason", map) : this.locale().get("playerJailedFor", map)) : this.locale().get("playerJailed", map);
                player.method_7353(text, false);
            }
        });
    }

    public void unjailPlayer(UUID uuid) {
        JailPlayerData data = this.getPlayer(uuid);
        data.jailed = false;
        data.teleportToPreviousLocation = true;
        class_3222 player = Solstice.server.method_3760().method_14602(uuid);
        if (player != null) {
            data.teleportToPreviousLocation = false;
            player.method_43496(this.locale().get("playerUnjailed"));
            if (data.previousLocation != null) {
                data.previousLocation.teleport(player);
            } else {
                ModuleProvider.SPAWN.getGlobalSpawnPosition().teleport(player);
            }
        }
    }
}

