/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.jail.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.ServerLocation;
import me.alexdevs.solstice.api.command.LocalGameProfile;
import me.alexdevs.solstice.api.command.TimeSpan;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.core.coreModule.data.CorePlayerData;
import me.alexdevs.solstice.modules.jail.JailModule;
import me.alexdevs.solstice.modules.jail.data.JailPlayerData;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class JailCommand
extends ModCommand<JailModule> {
    public JailCommand(JailModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("jail");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require("jail", 2))).then(class_2170.method_9244((String)"user", (ArgumentType)StringArgumentType.word()).suggests(LocalGameProfile::suggest).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"jail", (ArgumentType)StringArgumentType.word()).suggests(this::suggestJails).executes(context -> this.execute((CommandContext<class_2168>)context, 0, null))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"duration", (ArgumentType)TimeSpan.timeSpan()).suggests(TimeSpan::suggest).executes(context -> this.execute((CommandContext<class_2168>)context, TimeSpan.getTimeSpan((CommandContext<class_2168>)context, "duration"), null))).then(class_2170.method_9244((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.execute((CommandContext<class_2168>)context, TimeSpan.getTimeSpan((CommandContext<class_2168>)context, "duration"), StringArgumentType.getString((CommandContext)context, (String)"reason")))))));
    }

    private int execute(CommandContext<class_2168> context, int seconds, @Nullable String reason) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        GameProfile profile = LocalGameProfile.getProfile(context, "user");
        JailPlayerData data = ((JailModule)this.module).getPlayer(profile.getId());
        CorePlayerData coreData = Solstice.playerData.get(profile.getId()).getData(CorePlayerData.class);
        if (data.jailed) {
            source.method_9226(() -> ((JailModule)this.module).locale().get("alreadyJailed"), false);
            return 0;
        }
        String jailName = StringArgumentType.getString(context, (String)"jail");
        Map<String, ServerLocation> jails = ((JailModule)this.module).getJails();
        if (!jails.containsKey(jailName)) {
            source.method_9226(() -> ((JailModule)this.module).locale().get("jailNotFound"), false);
            return 0;
        }
        Permissions.check((GameProfile)profile, (String)this.getPermissionNode("exempt")).thenAccept(granted -> {
            if (granted.booleanValue()) {
                source.method_9226(() -> ((JailModule)this.module).locale().get("playerExempt"), false);
                return;
            }
            class_3222 player = source.method_9211().method_3760().method_14602(profile.getId());
            data.jailed = true;
            data.jailedBy = source.method_43737() ? source.method_44023().method_5667() : new UUID(0L, 0L);
            data.jailedOn = new Date();
            data.jailName = jailName;
            data.jailTime = seconds;
            data.jailReason = reason;
            data.previousLocation = player != null ? new ServerLocation(player) : coreData.logoffPosition;
            Map<String, class_2561> map = Map.of("player", class_2561.method_30163((String)profile.getName()), "jail", class_2561.method_30163((String)jailName), "duration", class_2561.method_30163((String)TimeSpan.toLongString(seconds)), "reason", class_2561.method_30163((String)reason));
            class_2561 text = seconds > 0 ? (reason != null ? ((JailModule)this.module).locale().get("jailedForWithReason", map) : ((JailModule)this.module).locale().get("jailedFor", map)) : ((JailModule)this.module).locale().get("jailed", map);
            source.method_9226(() -> text, true);
            if (player != null) {
                ((JailModule)this.module).sendToJail(player);
            }
        });
        return 1;
    }

    private CompletableFuture<Suggestions> suggestJails(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        Stream jails = ((JailModule)this.module).getJails().keySet().stream();
        return class_2172.method_9264(jails, (SuggestionsBuilder)builder);
    }
}

