/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.kit;

import java.util.Date;
import java.util.List;
import java.util.Map;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.events.SolsticeEvents;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.modules.kit.Utils;
import me.alexdevs.solstice.modules.kit.commands.KitCommand;
import me.alexdevs.solstice.modules.kit.commands.KitsCommand;
import me.alexdevs.solstice.modules.kit.data.Kit;
import me.alexdevs.solstice.modules.kit.data.KitConfig;
import me.alexdevs.solstice.modules.kit.data.KitLocale;
import me.alexdevs.solstice.modules.kit.data.KitPlayerData;
import me.alexdevs.solstice.modules.kit.data.KitServerData;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class KitModule
extends ModuleBase.Toggleable {
    public KitModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        this.registerConfig(KitConfig.class, KitConfig::new);
        this.registerLocale(KitLocale.MODULE);
        this.registerPlayerData(KitPlayerData.class, KitPlayerData::new);
        this.registerServerData(KitServerData.class, KitServerData::new);
        this.commands.add(new KitCommand(this));
        this.commands.add(new KitsCommand(this));
        SolsticeEvents.WELCOME.register((player, server) -> {
            for (Map.Entry<String, Kit> kit : this.getKits().entrySet()) {
                if (!kit.getValue().firstJoin) continue;
                this.claimKit(player, kit.getKey());
            }
        });
    }

    public Map<String, Kit> getKits() {
        return Solstice.serverData.getData(KitServerData.class).kits;
    }

    public boolean createKit(String name, List<class_1799> items) {
        Map<String, Kit> kits = this.getKits();
        if (kits.containsKey(name)) {
            return false;
        }
        Kit kit = new Kit();
        kit.itemStacks = items.stream().map(Utils::serializeItemStack).toList();
        kits.put(name, kit);
        return true;
    }

    public void claimKit(class_3222 player, String name) {
        KitPlayerData playerData = Solstice.playerData.get(player).getData(KitPlayerData.class);
        Kit kit = this.getKits().get(name);
        List<class_1799> items = kit.getItemStacks();
        class_1661 inventory = player.method_31548();
        for (class_1799 stack : items) {
            inventory.method_7394(stack);
        }
        playerData.claimedKits.put(name, new Date());
    }

    public boolean hasKitPermission(class_3222 player, String name) {
        KitConfig config = Solstice.configManager.getData(KitConfig.class);
        if (config.requirePermission) {
            return Permissions.check((class_1297)player, (String)this.getPermissionNode("kits." + name), (int)2);
        }
        return Permissions.check((class_1297)player, (String)this.getPermissionNode("kits." + name), (boolean)true);
    }

    public boolean couldClaimKit(class_3222 player, String name) {
        Kit kit = this.getKits().get(name);
        KitPlayerData playerData = Solstice.playerData.get(player).getData(KitPlayerData.class);
        if (kit.oneTime && playerData.claimedKits.containsKey(name)) {
            return false;
        }
        if (kit.cooldownSeconds > 0 && playerData.claimedKits.containsKey(name)) {
            Date startDate = playerData.claimedKits.get(name);
            Date nowDate = new Date();
            long delta = (nowDate.getTime() - startDate.getTime()) / 1000L;
            return delta >= (long)kit.cooldownSeconds;
        }
        return true;
    }

    public List<String> getPlayerKitNames(class_3222 player) {
        return this.getKits().keySet().stream().filter(kit -> this.hasKitPermission(player, (String)kit)).toList();
    }
}

