/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.kit.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.kit.KitModule;
import me.alexdevs.solstice.modules.kit.data.Kit;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class KitsCommand
extends ModCommand<KitModule> {
    private static final LinkedHashMap<Integer, class_3917<class_1707>> invSizes = new LinkedHashMap();

    public KitsCommand(KitModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("kits");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require(true))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            List<String> playerAvailableKits = ((KitModule)this.module).getPlayerKitNames(player);
            int size = playerAvailableKits.size();
            class_3917<class_1707> handlerType = null;
            for (Map.Entry<Integer, class_3917<class_1707>> entry : invSizes.entrySet()) {
                handlerType = entry.getValue();
                if (size > entry.getKey()) continue;
                break;
            }
            SimpleGui gui = new SimpleGui(handlerType, player, false);
            this.refreshGui((CommandContext<class_2168>)context, gui);
            gui.setTitle(((KitModule)this.module).locale().get("kits"));
            gui.open();
            return 1;
        });
    }

    private void refreshGui(CommandContext<class_2168> context, SimpleGui gui) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        List<String> playerAvailableKits = ((KitModule)this.module).getPlayerKitNames(player);
        Map<String, Kit> kits = ((KitModule)this.module).getKits();
        int size = playerAvailableKits.size();
        for (int i = 0; i < Math.min(size, 54); ++i) {
            class_2561 kitLoreComponent;
            class_2561 kitNameComponent;
            String kitName = playerAvailableKits.get(i);
            Kit kit = kits.get(kitName);
            boolean canClaim = ((KitModule)this.module).couldClaimKit(player, kitName);
            class_1799 icon = kit.getIcon();
            Map<String, class_2561> placeholders = Map.of("kit", class_2561.method_30163((String)kitName));
            if (canClaim) {
                kitNameComponent = class_2561.method_30163((String)kitName);
                kitLoreComponent = ((KitModule)this.module).locale().get("claimKit", placeholders);
                icon.method_57379(class_9334.field_49641, (Object)true);
            } else {
                kitNameComponent = ((KitModule)this.module).locale().get("kitsUnavailableName", placeholders);
                kitLoreComponent = ((KitModule)this.module).locale().get("kitsUnavailableLore", placeholders);
            }
            icon.method_57379(class_9334.field_49631, (Object)kitNameComponent);
            icon.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(kitLoreComponent)));
            gui.setSlot(i, (GuiElementInterface)new GuiElement(icon, (syncId, clickType, slotActionType) -> {
                try {
                    this.dispatcher.execute("kit claim " + kitName, (Object)((class_2168)context.getSource()));
                    this.refreshGui(context, gui);
                }
                catch (CommandSyntaxException e) {
                    ((class_2168)context.getSource()).method_9213(class_2561.method_30163((String)e.getLocalizedMessage()));
                }
            }));
        }
    }

    static {
        invSizes.put(9, (class_3917<class_1707>)class_3917.field_18664);
        invSizes.put(18, (class_3917<class_1707>)class_3917.field_18665);
        invSizes.put(27, (class_3917<class_1707>)class_3917.field_17326);
        invSizes.put(36, (class_3917<class_1707>)class_3917.field_18666);
        invSizes.put(45, (class_3917<class_1707>)class_3917.field_18667);
        invSizes.put(54, (class_3917<class_1707>)class_3917.field_17327);
    }
}

