/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.mail.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.node.TextNode;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import me.alexdevs.solstice.api.command.LocalGameProfile;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.api.text.Components;
import me.alexdevs.solstice.api.text.parser.MarkdownParser;
import me.alexdevs.solstice.core.coreModule.CoreModule;
import me.alexdevs.solstice.modules.ModuleProvider;
import me.alexdevs.solstice.modules.mail.MailModule;
import me.alexdevs.solstice.modules.mail.data.PlayerMail;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class MailCommand
extends ModCommand<MailModule> {
    public MailCommand(MailModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("mail");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require(true))).executes(this::listMails)).then(class_2170.method_9247((String)"send").then(class_2170.method_9244((String)"recipient", (ArgumentType)StringArgumentType.word()).suggests(LocalGameProfile::suggest).then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(this::sendMail))))).then(class_2170.method_9247((String)"read").then(class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::readMail)))).then(class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::deleteMail)));
    }

    private int listMails(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
        List<PlayerMail> mails = ((MailModule)this.module).getMailList(player.method_5667());
        if (mails.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> ((MailModule)this.module).locale().get("emptyMailbox", playerContext), false);
            return 0;
        }
        class_5250 output = class_2561.method_43473().method_10852(((MailModule)this.module).locale().get("mailListHeader", playerContext)).method_10852(class_2561.method_30163((String)"\n"));
        for (int i = 0; i < mails.size(); ++i) {
            if (i > 0) {
                output = output.method_10852(class_2561.method_30163((String)"\n"));
            }
            PlayerMail mail = mails.get(i);
            int index = i + 1;
            class_2561 readButton = Components.button(((MailModule)this.module).locale().raw("readButton"), ((MailModule)this.module).locale().raw("hoverRead"), "/mail read " + index);
            String senderName = CoreModule.getUsername(mail.sender);
            SimpleDateFormat dateFormatter = new SimpleDateFormat(CoreModule.getConfig().dateTimeFormat);
            Map<String, class_2561> placeholders = Map.of("index", class_2561.method_30163((String)String.valueOf(index)), "sender", class_2561.method_30163((String)senderName), "date", class_2561.method_30163((String)dateFormatter.format(mail.date)), "readButton", readButton);
            output = output.method_10852(((MailModule)this.module).locale().get("mailListEntry", playerContext, placeholders));
        }
        class_5250 finalOutput = output;
        ((class_2168)context.getSource()).method_9226(() -> finalOutput, false);
        return 1;
    }

    private int readMail(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
        List<PlayerMail> mails = ((MailModule)this.module).getMailList(player.method_5667());
        int index = IntegerArgumentType.getInteger(context, (String)"index") - 1;
        if (index < 0 || index >= mails.size()) {
            ((class_2168)context.getSource()).method_9226(() -> ((MailModule)this.module).locale().get("notFound"), false);
            return 0;
        }
        PlayerMail mail = mails.get(index);
        String username = CoreModule.getUsername(mail.sender);
        class_2561 replyButton = Components.buttonSuggest(((MailModule)this.module).locale().raw("replyButton"), ((MailModule)this.module).locale().raw("hoverReply"), "/mail send " + username + " ");
        class_2561 deleteButton = Components.button(((MailModule)this.module).locale().raw("deleteButton"), ((MailModule)this.module).locale().raw("hoverDelete"), "/mail delete " + index + "1");
        String senderName = CoreModule.getUsername(mail.sender);
        SimpleDateFormat dateFormatter = new SimpleDateFormat(CoreModule.getConfig().dateTimeFormat);
        TextNode message = MarkdownParser.defaultParser.parseNode(mail.message);
        Map<String, class_2561> placeholders = Map.of("sender", class_2561.method_30163((String)senderName), "date", class_2561.method_30163((String)dateFormatter.format(mail.date)), "message", message.toText(), "replyButton", replyButton, "deleteButton", deleteButton);
        ((class_2168)context.getSource()).method_9226(() -> ((MailModule)this.module).locale().get("mailDetails", playerContext, placeholders), false);
        return 1;
    }

    private int deleteMail(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
        int index = IntegerArgumentType.getInteger(context, (String)"index") - 1;
        if (((MailModule)this.module).deleteMail(player.method_5667(), index)) {
            ((class_2168)context.getSource()).method_9226(() -> ((MailModule)this.module).locale().get("mailDeleted", playerContext), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> ((MailModule)this.module).locale().get("notFound"), false);
        }
        return 1;
    }

    private int sendMail(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 sender = ((class_2168)context.getSource()).method_9207();
        GameProfile recipient = LocalGameProfile.getProfile(context, "recipient");
        String message = StringArgumentType.getString(context, (String)"message");
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        PlayerMail mail = new PlayerMail(message, sender.method_5667());
        boolean actuallySent = ((MailModule)this.module).sendMail(recipient.getId(), mail);
        PlaceholderContext senderContext = PlaceholderContext.of((class_3222)sender);
        ((class_2168)context.getSource()).method_9226(() -> ((MailModule)this.module).locale().get("mailSent", senderContext), false);
        if (actuallySent) {
            class_3222 recPlayer = server.method_3760().method_14602(recipient.getId());
            if (recPlayer == null) {
                return 1;
            }
            if (ModuleProvider.IGNORE.isIgnoring(recPlayer, sender)) {
                return 0;
            }
            PlaceholderContext recContext = PlaceholderContext.of((class_3222)recPlayer);
            recPlayer.method_43496(((MailModule)this.module).locale().get("mailReceived", recContext));
        }
        return 1;
    }
}

