/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.mute.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.command.TimeSpan;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.mute.MuteModule;
import me.alexdevs.solstice.modules.mute.data.MutePlayerData;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2561;

public class MuteCommand
extends ModCommand<MuteModule> {
    public MuteCommand(MuteModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("mute");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).executes(context -> this.execute((CommandContext<class_2168>)context, 0))).then(class_2170.method_9244((String)"timespan", (ArgumentType)TimeSpan.timeSpan()).suggests(TimeSpan::suggest).executes(context -> this.execute((CommandContext<class_2168>)context, TimeSpan.getTimeSpan((CommandContext<class_2168>)context, "timespan")))));
    }

    private int execute(CommandContext<class_2168> context, int timespan) throws CommandSyntaxException {
        Collection targets = class_2191.method_9330(context, (String)"targets");
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, timespan);
        Date date = calendar.getTime();
        targets.forEach(profile -> {
            MutePlayerData playerData = ((MuteModule)this.module).getPlayerData(profile.getId());
            playerData.muted = true;
            if (timespan != 0) {
                playerData.mutedUntil = date;
            }
        });
        Solstice.playerData.saveAll();
        String localeKey = timespan == 0 ? (targets.size() == 1 ? "muted" : "mutedMultiple") : (targets.size() == 1 ? "mutedTimespan" : "mutedMultipleTimespan");
        Map<String, class_2561> placeholders = Map.of("count", class_2561.method_30163((String)String.valueOf(targets.size())), "player", class_2561.method_30163((String)((GameProfile)targets.stream().findFirst().get()).getName()), "timespan", class_2561.method_30163((String)TimeSpan.toLongString(timespan)));
        ((class_2168)context.getSource()).method_9226(() -> ((MuteModule)this.module).locale().get(localeKey, placeholders), true);
        return 1;
    }
}

